#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 haskell-src-exts
version:              1.23.1
visibility:           public
id:                   haskell-src-exts-1.23.1-5wKcEPhCYtCDMpJskTRGU9
key:                  haskell-src-exts-1.23.1-5wKcEPhCYtCDMpJskTRGU9
license:              BSD-3-Clause
maintainer:           Dan Burton <danburton.email@gmail.com>
author:               Niklas Broberg
stability:            Stable
homepage:             https://github.com/haskell-suite/haskell-src-exts
synopsis:
    Manipulating Haskell source: abstract syntax, lexer, parser, and pretty-printer

description:
    Haskell-Source with Extensions (HSE, haskell-src-exts)
    is a standalone parser for Haskell. In addition to
    standard Haskell, all extensions implemented in GHC are supported.

    Apart from these standard extensions,
    it also handles regular patterns as per the HaRP extension
    as well as HSX-style embedded XML syntax.

category:             Language
abi:                  27491b137efb4857de10a93b1e1999ba
exposed:              True
exposed-modules:
    Language.Haskell.Exts Language.Haskell.Exts.Build
    Language.Haskell.Exts.Comments Language.Haskell.Exts.ExactPrint
    Language.Haskell.Exts.Extension Language.Haskell.Exts.Fixity
    Language.Haskell.Exts.Lexer Language.Haskell.Exts.Parser
    Language.Haskell.Exts.Pretty Language.Haskell.Exts.SrcLoc
    Language.Haskell.Exts.Syntax

hidden-modules:
    Language.Haskell.Exts.ExtScheme Language.Haskell.Exts.ParseMonad
    Language.Haskell.Exts.ParseSyntax
    Language.Haskell.Exts.InternalLexer
    Language.Haskell.Exts.ParseUtils
    Language.Haskell.Exts.InternalParser Language.Preprocessor.Unlit

import-dirs:          /usr/lib/ghc-9.2.8/site-local/haskell-src-exts-1.23.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/haskell-src-exts-1.23.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-src-exts
hs-libraries:         HShaskell-src-exts-1.23.1-5wKcEPhCYtCDMpJskTRGU9
depends:
    array-0.5.4.0 base-4.16.4.0 ghc-prim-0.8.0 pretty-1.1.3.6

haddock-interfaces:
    /usr/share/doc/haskell-src-exts/html/haskell-src-exts.haddock

haddock-html:         /usr/share/doc/haskell-src-exts/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

