#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 snap-server
version:              1.1.2.1
visibility:           public
id:                   snap-server-1.1.2.1-JoHpCfIc5rC8yc7i3HrRky
key:                  snap-server-1.1.2.1-JoHpCfIc5rC8yc7i3HrRky
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors  (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             A web server for the Snap Framework
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    The Snap HTTP server is a high performance web server library written in
    Haskell. Together with the @snap-core@ library upon which it depends, it
    provides a clean and efficient Haskell programming interface to the HTTP
    protocol.

category:             Web, Snap, IO-Streams
abi:                  f9086b22c76ada2e83a6b7af0ed4255e
exposed:              True
exposed-modules:
    Snap.Http.Server Snap.Http.Server.Config Snap.Http.Server.Types
    Snap.Internal.Http.Server.Config Snap.Internal.Http.Server.Types
    System.FastLogger

hidden-modules:
    Paths_snap_server Control.Concurrent.Extended
    Snap.Internal.Http.Server.Address Snap.Internal.Http.Server.Clock
    Snap.Internal.Http.Server.Common Snap.Internal.Http.Server.Date
    Snap.Internal.Http.Server.Parser Snap.Internal.Http.Server.Session
    Snap.Internal.Http.Server.Socket Snap.Internal.Http.Server.Thread
    Snap.Internal.Http.Server.TimeoutManager
    Snap.Internal.Http.Server.TLS System.SendFile System.SendFile.Linux

import-dirs:          /usr/lib/ghc-9.2.8/site-local/snap-server-1.1.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/snap-server-1.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-server
hs-libraries:         HSsnap-server-1.1.2.1-JoHpCfIc5rC8yc7i3HrRky
depends:
    attoparsec-0.14.4-DN7s9Fr9c113K5agmmE0LB base-4.16.4.0
    blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK bytestring-0.11.4.0
    case-insensitive-1.2.1.0-C9u4G83SV6G4MBj88LrUbo
    clock-0.8.4-Kzh7X2kPtrQ91MTkkNH1hr containers-0.6.5.1
    filepath-1.4.2.2 io-streams-1.5.2.2-D3kNbL7qUGO6OCiY4i9LSN
    io-streams-haproxy-1.0.1.0-7BKfqAUQI9fFAAZuXw1kdC
    lifted-base-0.2.3.12-Eg70FOm0hWa5vTPmDqrazt mtl-2.2.2
    network-3.1.4.0-I7hY9PROidqFfCvyq23hqh
    old-locale-1.0.0.7-DSFeUNZwxUU2YUIlh1bsq7
    snap-core-1.0.5.1-D3fofz6P2sCH2BjsNdfgxc text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.7.2-9EkyOdRG6Oq7mRyWipBzHf
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:   /usr/share/doc/haskell-snap-server/html/snap-server.haddock
haddock-html:         /usr/share/doc/haskell-snap-server/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

