#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 serialise
version:              0.2.6.1
visibility:           public
id:                   serialise-0.2.6.1-9yUtu9tUhWxC6H0oy4Gc4w
key:                  serialise-0.2.6.1-9yUtu9tUhWxC6H0oy4Gc4w
license:              BSD-3-Clause
copyright:
    2015-2017 Duncan Coutts,
    2015-2017 Well-Typed LLP,
    2015 IRIS Connect Ltd

maintainer:           duncan@community.haskell.org, ben@smart-cactus.org
author:               Duncan Coutts
homepage:             https://github.com/well-typed/cborg
synopsis:             A binary serialisation library for Haskell values.
description:
    This package (formerly @binary-serialise-cbor@) provides pure, efficient
    serialization of Haskell values directly into @ByteString@s for storage or
    transmission purposes. By providing a set of type class instances, you can
    also serialise any custom data type you have as well.

    The underlying binary format used is the '\''Concise Binary Object
    Representation'\'', or CBOR, specified in RFC 7049. As a result,
    serialised Haskell values have implicit structure outside of the
    Haskell program itself, meaning they can be inspected or analyzed
    without custom tools.

    An implementation of the standard bijection between CBOR and JSON is provided
    by the [cborg-json](/package/cborg-json) package. Also see
    [cbor-tool](/package/cbor-tool) for a convenient command-line utility for
    working with CBOR data.

category:             Codec
abi:                  39fbb435cc71159a27f1346c5b57e738
exposed:              True
exposed-modules:
    Codec.Serialise Codec.Serialise.Class Codec.Serialise.Decoding
    Codec.Serialise.Encoding Codec.Serialise.IO
    Codec.Serialise.Internal.GeneralisedUTF8 Codec.Serialise.Properties
    Codec.Serialise.Tutorial

import-dirs:          /usr/lib/ghc-9.2.8/site-local/serialise-0.2.6.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/serialise-0.2.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-serialise
hs-libraries:         HSserialise-0.2.6.1-9yUtu9tUhWxC6H0oy4Gc4w
depends:
    array-0.5.4.0 base-4.16.4.0 bytestring-0.11.4.0
    cborg-0.2.9.0-BZoFQ20pvIXBegBretBcdJ containers-0.6.5.1
    ghc-prim-0.8.0 half-0.3.1-IptsrnsqsMaJKU0FfRAFm8
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    primitive-0.7.4.0-I9XTAmFqErC1hXdXvvNzkS
    strict-0.4.0.1-8lBzBTysaJf7j59NPrtuU7 text-1.2.5.0
    these-1.1.1.1-IjaKzDKQUlV4D72LRxTl4W time-1.11.1.1
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:   /usr/share/doc/haskell-serialise/html/serialise.haddock
haddock-html:         /usr/share/doc/haskell-serialise/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

