#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 semialign
version:              1.2.0.1
visibility:           public
id:                   semialign-1.2.0.1-FwAdcScZlCCAOTpXC8sBnb
key:                  semialign-1.2.0.1-FwAdcScZlCCAOTpXC8sBnb
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  ffc5810812a7205a20d3ed6d3660355b
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.2.8/site-local/semialign-1.2.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/semialign-1.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.2.0.1-FwAdcScZlCCAOTpXC8sBnb
depends:
    base-4.16.4.0 containers-0.6.5.1
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    indexed-traversable-0.1.4-6wPCwLr0dTz5YsFQcHKUoV
    indexed-traversable-instances-0.1.2-CF9FQ6BQ4jeBo8LbV3unFM
    semigroupoids-5.3.7-CmdCtkiMB79IiDSsUdUQis
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg
    these-1.1.1.1-IjaKzDKQUlV4D72LRxTl4W transformers-0.5.6.2
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

