#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 selective
version:              0.6
visibility:           public
id:                   selective-0.6-GhdH5GZguXB3X0XfoF0ByH
key:                  selective-0.6-GhdH5GZguXB3X0XfoF0ByH
license:              MIT
copyright:            Andrey Mokhov, 2018-2023
maintainer:
    Andrey Mokhov <andrey.mokhov@gmail.com>, github: @snowleopard

author:
    Andrey Mokhov <andrey.mokhov@gmail.com>, github: @snowleopard

homepage:             https://github.com/snowleopard/selective
synopsis:             Selective applicative functors
description:
    Selective applicative functors: declare your effects statically,
    select which to execute dynamically.

    This is a library for /selective applicative functors/, or just
    /selective functors/ for short, an abstraction between
    applicative functors and monads, introduced in
    <https://www.staff.ncl.ac.uk/andrey.mokhov/selective-functors.pdf this paper>.

category:             Control
abi:                  e028680bde4aefdefd4200b48cd65c1b
exposed:              True
exposed-modules:
    Control.Selective Control.Selective.Free Control.Selective.Multi
    Control.Selective.Rigid.Free Control.Selective.Rigid.Freer
    Control.Selective.Trans.Except

import-dirs:          /usr/lib/ghc-9.2.8/site-local/selective-0.6
library-dirs:         /usr/lib/ghc-9.2.8/site-local/selective-0.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-selective
hs-libraries:         HSselective-0.6-GhdH5GZguXB3X0XfoF0ByH
depends:              base-4.16.4.0 containers-0.6.5.1 transformers-0.5.6.2
haddock-interfaces:   /usr/share/doc/haskell-selective/html/selective.haddock
haddock-html:         /usr/share/doc/haskell-selective/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

