#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-FIU8pfZBvZHfvLkeU4e0i
key:                  scotty-0.22-FIU8pfZBvZHfvLkeU4e0i
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  b6ed7ad6ae6987902c7164f06558da5a
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.2.8/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.2.8/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-FIU8pfZBvZHfvLkeU4e0i
depends:
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6 base-4.16.4.0
    blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK bytestring-0.11.4.0
    case-insensitive-1.2.1.0-C9u4G83SV6G4MBj88LrUbo
    cookie-0.4.6-ATAyIjNvKdDFVIoN0dB8l5
    data-default-class-0.1.2.0-Kt3ErptCt5hHHi8l61h1Gp exceptions-0.10.4
    http-types-0.12.4-G97153ZIeGq6X7uXEs2l2V
    monad-control-1.0.3.1-CA1GlfSV3Rl4gDTt4Ny2FB mtl-2.2.2
    network-3.1.4.0-I7hY9PROidqFfCvyq23hqh
    regex-compat-0.95.2.1-6r4iKSNuQHkEjgz1ilm8wy
    resourcet-1.2.6-AIugU9tehxw9mXWKxKfb0b stm-2.5.0.2 text-1.2.5.0
    time-1.11.1.1 transformers-0.5.6.2
    transformers-base-0.4.6-Jo7hBiquY6Q1je3XsS9imU
    unliftio-0.2.25.0-I5KL8dbXVmE3dWILMxzDhI
    wai-3.2.4-BNQtAxBTTmbBe7Crr2a2xg
    wai-extra-3.1.15-9pU0z7iIsCu8vLAVmw1tBo
    warp-3.3.30-JQuxlSSi13uLhX74fYOoJn

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

