#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ral
version:              0.2.1
visibility:           public
id:                   ral-0.2.1-EoOqtHoh73jGykpeRn3Gwj
key:                  ral-0.2.1-EoOqtHoh73jGykpeRn3Gwj
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  d9d5553d50d8a88c038d0c469b4f5109
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.2.8/site-local/ral-0.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/ral-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.1-EoOqtHoh73jGykpeRn3Gwj
depends:
    QuickCheck-2.14.3-5Q3LTiKAdB0LFKfPwDt7Ga
    adjunctions-4.4.2-2yrfc7tCgSW5Xh0sCgpzqX base-4.16.4.0
    bin-0.1.3-Fo7pLH1YDJU7Z3uJu1WBF boring-0.2.1-Icfsg6aSH6SpFFKOquZU
    deepseq-1.4.6.1 distributive-0.6.2.1-KoSgyLnWo6n6ePz6ij9ZFj
    fin-0.3-DqET4V14Sx0LknkyqdEtQe
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    indexed-traversable-0.1.4-6wPCwLr0dTz5YsFQcHKUoV
    semigroupoids-5.3.7-CmdCtkiMB79IiDSsUdUQis

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

