#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 QuickCheck-safe
version:              0.1.0.6
visibility:           public
id:                   QuickCheck-safe-0.1.0.6-91sLgjfc0SS8MI0ofhCDob
key:                  QuickCheck-safe-0.1.0.6-91sLgjfc0SS8MI0ofhCDob
license:              MIT
copyright:            2015,2017 Bertram Felgenhauer
maintainer:           Bertram Felgenhauer <int-e@gmx.de>
author:               Bertram Felgenhauer
synopsis:             Safe reimplementation of QuickCheck'\''s core
description:
    QuickCheck-safe reimplements the quickCheck functionality with a pure
    interface and a very small trusted base (see Test.QuickCheck.Safe.Trusted).

    * uses the existing Arbitrary instances
    * implemented features: testing, result minimization (i.e., shrinking)
    * missing features: expected failures, label frequencies, coverage

    The package is targeted at users who want to leverage SafeHaskell for
    sandboxing.

    >>> putStr $ quickCheck (inventQCGen ()) (\x -> length (x :: [()]) < 10)
    *** Failed! Falsifiable (after 18 tests and 3 shrinks):
    [(),(),(),(),(),(),(),(),(),(),(),(),(),(),()]

category:             Testing
abi:                  6cee195e84fb5ea26e344e008f3dc98c
exposed:              True
exposed-modules:      Test.QuickCheck.Safe Test.QuickCheck.Safe.Trusted
import-dirs:          /usr/lib/ghc-9.2.8/site-local/QuickCheck-safe-0.1.0.6
library-dirs:         /usr/lib/ghc-9.2.8/site-local/QuickCheck-safe-0.1.0.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-safe
hs-libraries:         HSQuickCheck-safe-0.1.0.6-91sLgjfc0SS8MI0ofhCDob
depends:
    QuickCheck-2.14.3-5Q3LTiKAdB0LFKfPwDt7Ga base-4.16.4.0
    containers-0.6.5.1

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-safe/html/QuickCheck-safe.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-safe/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

