#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 quickcheck-classes
version:              0.6.5.0
visibility:           public
id:                   quickcheck-classes-0.6.5.0-H93bvL2g6Z9DjAl0J3zQh1
key:                  quickcheck-classes-0.6.5.0-H93bvL2g6Z9DjAl0J3zQh1
license:              BSD-3-Clause
copyright:            2018 Andrew Martin
maintainer:           andrew.thaddeus@gmail.com
author:               Andrew Martin, chessai
homepage:             https://github.com/andrewthad/quickcheck-classes#readme
synopsis:             QuickCheck common typeclasses
description:
    This library provides QuickCheck properties to ensure
    that typeclass instances adhere to the set of laws that
    they are supposed to. There are other libraries that do
    similar things, such as `genvalidity-hspec` and `checkers`.
    This library differs from other solutions by not introducing
    any new typeclasses that the user needs to learn.

    /Note:/ on GHC < 8.5, this library uses the higher-kinded typeclasses
    ('\''Data.Functor.Classes.Show1'\'', '\''Data.Functor.Classes.Eq1'\'', '\''Data.Functor.Classes.Ord1'\'', etc.),
    but on GHC >= 8.5, it uses `-XQuantifiedConstraints` to express these
    constraints more cleanly.

category:             Testing
abi:                  31d56830a6831058346743354e68533b
exposed:              True
exposed-modules:
    Test.QuickCheck.Classes Test.QuickCheck.Classes.IsList

hidden-modules:
    Test.QuickCheck.Classes.Alt Test.QuickCheck.Classes.Apply
    Test.QuickCheck.Classes.Euclidean Test.QuickCheck.Classes.Json
    Test.QuickCheck.Classes.MVector Test.QuickCheck.Classes.Plus
    Test.QuickCheck.Classes.Prim Test.QuickCheck.Classes.Semigroupoid
    Test.QuickCheck.Classes.Semiring Test.QuickCheck.Classes.Ring

import-dirs:          /usr/lib/ghc-9.2.8/site-local/quickcheck-classes-0.6.5.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/quickcheck-classes-0.6.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-classes
hs-libraries:         HSquickcheck-classes-0.6.5.0-H93bvL2g6Z9DjAl0J3zQh1
depends:
    QuickCheck-2.14.3-5Q3LTiKAdB0LFKfPwDt7Ga
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6 base-4.16.4.0
    containers-0.6.5.1 primitive-0.7.4.0-I9XTAmFqErC1hXdXvvNzkS
    primitive-addr-0.1.0.2-4zrLtimEX6N5AuQB5ZjK6j
    quickcheck-classes-base-0.6.2.0-2E4G4IPAIj08NxiE1I9UxW
    semigroupoids-5.3.7-CmdCtkiMB79IiDSsUdUQis
    semirings-0.6-HL266gPKAtJE0G4EsZXs7Z transformers-0.5.6.2
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-classes/html/quickcheck-classes.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-classes/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

