#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 pandoc-lua-marshal
version:              0.2.7
visibility:           public
id:                   pandoc-lua-marshal-0.2.7-HjMq0EHdjpcCBgtKYTqOpX
key:                  pandoc-lua-marshal-0.2.7-HjMq0EHdjpcCBgtKYTqOpX
license:              MIT
copyright:            © 2017-2024 Albert Krewinkel, John MacFarlane
maintainer:           Albert Krewinkel <albert@zeitkraut.de>
author:               Albert Krewinkel, John MacFarlane
homepage:             https://github.com/pandoc/pandoc-lua-marshal
synopsis:             Use pandoc types in Lua
description:
    This package provides functions to marshal and unmarshal
    pandoc document types to and from Lua.

    The values of most types are pushed to pandoc as "userdata"
    objects that wrap a stable pointer to the Haskell value;
    these objects come with methods to access and modify their
    properties.

    Sequences are pushed as normal Lua tables, but are
    augmented with convenience functions.

category:             Foreign
abi:                  f20ce3108757d2e3eb2b78bf1e7fbd3f
exposed:              True
exposed-modules:
    Text.Pandoc.Lua.Marshal.AST Text.Pandoc.Lua.Marshal.Alignment
    Text.Pandoc.Lua.Marshal.Attr Text.Pandoc.Lua.Marshal.Block
    Text.Pandoc.Lua.Marshal.Cell Text.Pandoc.Lua.Marshal.Citation
    Text.Pandoc.Lua.Marshal.CitationMode
    Text.Pandoc.Lua.Marshal.Content Text.Pandoc.Lua.Marshal.Filter
    Text.Pandoc.Lua.Marshal.Format Text.Pandoc.Lua.Marshal.Inline
    Text.Pandoc.Lua.Marshal.List Text.Pandoc.Lua.Marshal.ListAttributes
    Text.Pandoc.Lua.Marshal.MathType Text.Pandoc.Lua.Marshal.MetaValue
    Text.Pandoc.Lua.Marshal.Pandoc Text.Pandoc.Lua.Marshal.QuoteType
    Text.Pandoc.Lua.Marshal.Row Text.Pandoc.Lua.Marshal.SimpleTable
    Text.Pandoc.Lua.Marshal.TableFoot Text.Pandoc.Lua.Marshal.TableHead
    Text.Pandoc.Lua.Marshal.TableParts

hidden-modules:
    Text.Pandoc.Lua.Marshal.Shared Text.Pandoc.Lua.Topdown
    Text.Pandoc.Lua.SpliceList Text.Pandoc.Lua.Walk

import-dirs:          /usr/lib/ghc-9.2.8/site-local/pandoc-lua-marshal-0.2.7
library-dirs:         /usr/lib/ghc-9.2.8/site-local/pandoc-lua-marshal-0.2.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc-lua-marshal
hs-libraries:         HSpandoc-lua-marshal-0.2.7-HjMq0EHdjpcCBgtKYTqOpX
depends:
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6 base-4.16.4.0
    bytestring-0.11.4.0 containers-0.6.5.1 exceptions-0.10.4
    hslua-2.3.0-KhPyeYpwu22KmCh6BLnBFj
    hslua-list-1.1.1-6iTWy9jOrx0KKcchlQhATa
    hslua-marshalling-2.3.1-GfiIDqwLJTiFJfYGxWLaEk
    pandoc-types-1.23.1-7mX6TZWk1606CnxNjKgydb
    safe-0.3.21-JdttgF4acvJfVRaNLAh text-1.2.5.0

haddock-interfaces:
    /usr/share/doc/haskell-pandoc-lua-marshal/html/pandoc-lua-marshal.haddock

haddock-html:         /usr/share/doc/haskell-pandoc-lua-marshal/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

