#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 z-pandoc-z-xml-light
version:              3.1.11.1
package-name:         pandoc
lib-name:             xml-light
id:                   pandoc-3.1.11.1-1xIzZH4zcbQ4CVVg9ysoiZ-xml-light
key:                  pandoc-3.1.11.1-1xIzZH4zcbQ4CVVg9ysoiZ-xml-light
license:              GPL-2.0-or-later
copyright:            (c) 2006-2023 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  aec102efb6cc3fe83b03ac68b2261a95
exposed-modules:
    Text.Pandoc.XML.Light Text.Pandoc.XML.Light.Output
    Text.Pandoc.XML.Light.Proc Text.Pandoc.XML.Light.Types

import-dirs:          /usr/lib/ghc-9.2.8/site-local/pandoc-3.1.11.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/pandoc-3.1.11.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.1.11.1-1xIzZH4zcbQ4CVVg9ysoiZ-xml-light
depends:
    base-4.16.4.0 containers-0.6.5.1 text-1.2.5.0
    xml-1.3.14-6RhFPlxQprr192No4Dq3gf
    xml-conduit-1.9.1.4-6X2DGMUptWqJTYDzgF6m6x
    xml-types-0.3.8-LZyzf9bLT8K9kdiyyQ9IUF

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 pandoc
version:              3.1.11.1
visibility:           public
id:                   pandoc-3.1.11.1-75MECC3EW8kHMTDDVMKH0N
key:                  pandoc-3.1.11.1-75MECC3EW8kHMTDDVMKH0N
license:              GPL-2.0-or-later
copyright:            (c) 2006-2023 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  c170f9d64a8dc15a6063248945e134c2
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.Chunks
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Class.IO
    Text.Pandoc.Data Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Format
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.DokuWiki Text.Pandoc.Readers.EPUB
    Text.Pandoc.Readers.EndNote Text.Pandoc.Readers.FB2
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.Haddock
    Text.Pandoc.Readers.Ipynb Text.Pandoc.Readers.JATS
    Text.Pandoc.Readers.Jira Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.Man Text.Pandoc.Readers.Markdown
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.Muse
    Text.Pandoc.Readers.Native Text.Pandoc.Readers.ODT
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.Org
    Text.Pandoc.Readers.RIS Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.RTF Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.TikiWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Typst
    Text.Pandoc.Readers.Vimwiki Text.Pandoc.Scripting
    Text.Pandoc.SelfContained Text.Pandoc.Shared Text.Pandoc.Slides
    Text.Pandoc.Sources Text.Pandoc.Templates Text.Pandoc.Translations
    Text.Pandoc.Translations.Types Text.Pandoc.UTF8 Text.Pandoc.Version
    Text.Pandoc.Writers Text.Pandoc.Writers.AnnotatedTable
    Text.Pandoc.Writers.AsciiDoc Text.Pandoc.Writers.BibTeX
    Text.Pandoc.Writers.ChunkedHTML Text.Pandoc.Writers.CommonMark
    Text.Pandoc.Writers.ConTeXt Text.Pandoc.Writers.CslJson
    Text.Pandoc.Writers.DocBook Text.Pandoc.Writers.Docx
    Text.Pandoc.Writers.DokuWiki Text.Pandoc.Writers.EPUB
    Text.Pandoc.Writers.FB2 Text.Pandoc.Writers.HTML
    Text.Pandoc.Writers.Haddock Text.Pandoc.Writers.ICML
    Text.Pandoc.Writers.Ipynb Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.Jira Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.Man Text.Pandoc.Writers.Markdown
    Text.Pandoc.Writers.Math Text.Pandoc.Writers.MediaWiki
    Text.Pandoc.Writers.Ms Text.Pandoc.Writers.Muse
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.ODT
    Text.Pandoc.Writers.OOXML Text.Pandoc.Writers.OPML
    Text.Pandoc.Writers.OpenDocument Text.Pandoc.Writers.Org
    Text.Pandoc.Writers.Powerpoint Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.RTF Text.Pandoc.Writers.Shared
    Text.Pandoc.Writers.TEI Text.Pandoc.Writers.Texinfo
    Text.Pandoc.Writers.Textile Text.Pandoc.Writers.Typst
    Text.Pandoc.Writers.XWiki Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.Input
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.PandocMonad
    Text.Pandoc.Class.PandocIO Text.Pandoc.Class.PandocPure
    Text.Pandoc.Class.Sandbox Text.Pandoc.Filter.Environment
    Text.Pandoc.Filter.JSON Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Future
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Symbols Text.Pandoc.Readers.Docx.Fields
    Text.Pandoc.Readers.HTML.Parsing Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.Typst.Parsing
    Text.Pandoc.Readers.Typst.Math Text.Pandoc.Readers.ODT.Base
    Text.Pandoc.Readers.ODT.Namespaces
    Text.Pandoc.Readers.ODT.StyleReader
    Text.Pandoc.Readers.ODT.ContentReader
    Text.Pandoc.Readers.ODT.Generic.Fallible
    Text.Pandoc.Readers.ODT.Generic.SetMap
    Text.Pandoc.Readers.ODT.Generic.Utils
    Text.Pandoc.Readers.ODT.Generic.Namespaces
    Text.Pandoc.Readers.ODT.Generic.XMLConverter
    Text.Pandoc.Readers.ODT.Arrows.State
    Text.Pandoc.Readers.ODT.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.StyleMap
    Text.Pandoc.Writers.Docx.Table Text.Pandoc.Writers.Docx.Types
    Text.Pandoc.Writers.GridTable Text.Pandoc.Writers.JATS.References
    Text.Pandoc.Writers.JATS.Table Text.Pandoc.Writers.JATS.Types
    Text.Pandoc.Writers.LaTeX.Caption Text.Pandoc.Writers.LaTeX.Notes
    Text.Pandoc.Writers.LaTeX.Table Text.Pandoc.Writers.LaTeX.Lang
    Text.Pandoc.Writers.LaTeX.Types Text.Pandoc.Writers.LaTeX.Citation
    Text.Pandoc.Writers.LaTeX.Util Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.TeX
    Text.Pandoc.URI Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Image
    Text.Pandoc.Citeproc.BibTeX Text.Pandoc.Citeproc.Name
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.2.8/site-local/pandoc-3.1.11.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/pandoc-3.1.11.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.1.11.1-75MECC3EW8kHMTDDVMKH0N
depends:
    Glob-0.10.2-IUS0c8yYTOEJSZESSQNsvs
    JuicyPixels-3.3.8-4kgngwsvGuj90RaxMNOOcO
    SHA-1.6.4.4-4vZ3YEU9upt6TqgW7hflaa
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    aeson-pretty-0.8.10-1w3bzFq1eKcCRjNt7mV0fD array-0.5.4.0
    attoparsec-0.14.4-DN7s9Fr9c113K5agmmE0LB base-4.16.4.0
    base64-bytestring-1.2.1.0-74HkITi20nv2BdJvE3AKcV binary-0.8.9.0
    blaze-html-0.9.2.0-ARMUh31ndZFLabXVs8gk0N
    blaze-markup-0.8.3.0-HRiNog23ingBf0HHxn7tF0 bytestring-0.11.4.0
    case-insensitive-1.2.1.0-C9u4G83SV6G4MBj88LrUbo
    citeproc-0.8.1-BxqJpTzZVbwDJlPOxrQF0P
    commonmark-0.2.5.1-9LpwRCZddoY8QIXkVs0d9a
    commonmark-extensions-0.2.5.2-8rjFLpihecmJt9u4VGlIZq
    commonmark-pandoc-0.2.2.1-CgqisHXB20R8Bj5VXblpYy containers-0.6.5.1
    crypton-connection-0.3.2-36ppN3Gn6kYD8Dtpen9u1g
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS deepseq-1.4.6.1
    directory-1.3.6.2 doclayout-0.4.0.1-DOBWBghElu488UW1QaF49w
    doctemplates-0.11-22TRmmCvbvVLB2ILer36pE
    emojis-0.1.4-Zr9BNGybaPIbgyLliBqKn exceptions-0.10.4
    file-embed-0.0.15.0-4hNEx1vJ7JTC58fR03LKND filepath-1.4.2.2
    gridtables-0.1.0.0-K6YOUBeMVMKASeJpvrUjrc
    haddock-library-1.11.0-B34F6x2ya3XJyBFLOYzXMW
    http-client-0.7.17-JgdZSxk89UYJjfjCxx3dTH
    http-client-tls-0.3.6.3-9tLQnIY72wX7jTuvJ6seUd
    http-types-0.12.4-G97153ZIeGq6X7uXEs2l2V
    ipynb-0.2-Ki1jvknirSC3KEcR7toSPx
    jira-wiki-markup-1.5.1-4rJ6UEiyLH592Hqr6aruIi
    mime-types-0.1.2.0-4X5b6Sz1aAM6TugVqfWYtQ mtl-2.2.2
    network-3.1.4.0-I7hY9PROidqFfCvyq23hqh
    network-uri-2.6.4.2-EwAfSnfKix9WHRPnJWEEo
    pandoc-3.1.11.1-1xIzZH4zcbQ4CVVg9ysoiZ-xml-light
    pandoc-types-1.23.1-7mX6TZWk1606CnxNjKgydb parsec-3.1.15.0
    pretty-1.1.3.6 pretty-show-1.10-JwphvxEdk99BsHrT870tUy
    process-1.6.16.0 random-1.2.1.2-3aSfWlsu7xc3wK3TRJn2vY
    safe-0.3.21-JdttgF4acvJfVRaNLAh
    scientific-0.3.7.0-7nXcZobZD337Jkf1NR7gHa
    skylighting-0.14.1.1-88ubsJuyR2h95VQph78Rsh
    skylighting-core-0.14.1.1-FoL7prYrkuoFWDK62Kj8rJ
    split-0.2.5-Gzu4NbNnTUj6rs5DfMztSh
    syb-0.7.2.4-96PLGA9ePRoKEvwVQEltSr
    tagsoup-0.14.8-Ka8QuMFUNJz397ryjhzb8m
    temporary-1.3-FDskYhMei4uKi1JCFLXz31
    texmath-0.12.8.6-IDKaugEHaoC9XYb6aADB0u text-1.2.5.0
    text-conversions-0.3.1.1-KTkZnK03aCBDd0p7LfseId time-1.11.1.1
    typst-0.5.0.1-Ek9Oh0ZJb1qKnly1LeYZxR
    unicode-collation-0.1.3.6-8ZraWiiI1HnKIF4UbID6SK
    unicode-transforms-0.4.0.1-4fjK6ZRbOJjvlYXrVpEBl unix-2.7.2.2
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
    xml-1.3.14-6RhFPlxQprr192No4Dq3gf
    yaml-0.11.11.2-9MxOzRHsMDt4HQwRFFgCZL
    zip-archive-0.4.3.2-JoEJDrgiwOE77pKRvuA2GN
    zlib-0.6.3.0-3hvuMBy4V96vMim3ALKcj

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

