#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 nettle
version:              0.3.1.1
visibility:           public
id:                   nettle-0.3.1.1-IesfSaYKwdg21K60p9ny7B
key:                  nettle-0.3.1.1-IesfSaYKwdg21K60p9ny7B
license:              MIT
copyright:            Stefan Bühler <stbuehler@web.de>
maintainer:           Clint Adams <clint@debian.org>
author:               Stefan Bühler <stbuehler@web.de>
homepage:             https://github.com/stbuehler/haskell-nettle
synopsis:             safe nettle binding
description:
    safe binding for the nettle (<http://www.lysator.liu.se/~nisse/nettle/nettle.html>) library.
    Tested with 3.4, might work with 3.2 (but not earlier).

category:             Cryptography
abi:                  69cdd7c04395a627027dbb77158b2773
exposed:              True
exposed-modules:
    Crypto.Nettle.CCM Crypto.Nettle.ChaChaPoly1305
    Crypto.Nettle.Ciphers Crypto.Nettle.HMAC Crypto.Nettle.Hash
    Crypto.Nettle.KeyedHash Crypto.Nettle.UMAC

hidden-modules:
    Crypto.Nettle.Ciphers.Internal Crypto.Nettle.Ciphers.ForeignImports
    Crypto.Nettle.Hash.ForeignImports Crypto.Nettle.Hash.Types
    Nettle.Utils

import-dirs:          /usr/lib/ghc-9.2.8/site-local/nettle-0.3.1.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/nettle-0.3.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-nettle
hs-libraries:         HSnettle-0.3.1.1-IesfSaYKwdg21K60p9ny7B
extra-libraries:      nettle
depends:
    base-4.16.4.0 byteable-0.1.1-2aVcTelA6XA9YKIvhjRaxC
    bytestring-0.11.4.0
    crypto-cipher-types-0.0.9-JlEUy6YMnlQJGxVQmgyp8z
    securemem-0.1.10-EDfBRjlOKD136c0ZXJQIUL
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg

haddock-interfaces:   /usr/share/doc/haskell-nettle/html/nettle.haddock
haddock-html:         /usr/share/doc/haskell-nettle/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

