#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mueval
version:              0.9.3
visibility:           public
id:                   mueval-0.9.3-5SRNaK3hYYZHcaqGS2LixJ
key:                  mueval-0.9.3-5SRNaK3hYYZHcaqGS2LixJ
license:              BSD-3-Clause
maintainer:           Gwern <gwern@gwern.net>
author:               Gwern
homepage:             https://github.com/gwern/mueval
synopsis:             Safely evaluate pure Haskell expressions
description:
    Mueval is a Haskell interpreter. It
    uses the GHC API to evaluate arbitrary Haskell expressions.
    Importantly, mueval takes many precautions to defang and avoid \"evil\"
    code.  It uses resource limits, whitelisted modules and Safe Haskell,
    special Show instances for IO, threads, processes, and changes of directory
    to sandbox the Haskell code.

    It is, in short, intended to be a standalone version of Lambdabot'\''s famous
    evaluation functionality. For examples and explanations, please see the README file.

    Mueval is POSIX-only.

category:             Development, Language
abi:                  85b1831c654ec2cca4d409cea4a966ad
exposed:              True
exposed-modules:
    Mueval.ArgsParse Mueval.Context Mueval.Interpreter Mueval.Parallel
    Mueval.Resources

import-dirs:          /usr/lib/ghc-9.2.8/site-local/mueval-0.9.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/mueval-0.9.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mueval
hs-libraries:         HSmueval-0.9.3-5SRNaK3hYYZHcaqGS2LixJ
depends:
    Cabal-3.6.3.0 QuickCheck-2.14.3-5Q3LTiKAdB0LFKfPwDt7Ga
    base-4.16.4.0 containers-0.6.5.1 directory-1.3.6.2
    extensible-exceptions-0.1.1.4-D8VRIfPBfkhEPmMrxbU9lA
    filepath-1.4.2.2 hint-0.9.0.6-4d5qVxUTClaDzSrPwWoR77 mtl-2.2.2
    process-1.6.16.0 show-0.6-4MiH6Sn2jcGAB9ifNUZzrZ
    simple-reflect-0.3.3-6bzc2HjUkxQ8Qu7G3Z5hdc unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-mueval/html/mueval.haddock
haddock-html:         /usr/share/doc/haskell-mueval/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

