#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 math-functions
version:              0.3.4.4
visibility:           public
id:                   math-functions-0.3.4.4-4t3X6AVXtzGCUa2A4nrWTl
key:                  math-functions-0.3.4.4-4t3X6AVXtzGCUa2A4nrWTl
license:              BSD-2-Clause
maintainer:           Alexey Khudyakov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>,
    Alexey Khudyakov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/math-functions
synopsis:             Collection of tools for numeric computations
description:
    This library contain collection of various utilities for numerical
    computing. So far there'\''re special mathematical functions,
    compensated summation algorithm, summation of series, root finding
    for real functions, polynomial summation and Chebyshev
    polynomials.

category:             Math, Numeric
abi:                  c71ca4b4bf0b7452dece2f8a50d74ff7
exposed:              True
exposed-modules:
    Numeric.MathFunctions.Comparison Numeric.MathFunctions.Constants
    Numeric.Polynomial Numeric.Polynomial.Chebyshev Numeric.RootFinding
    Numeric.Series Numeric.SpecFunctions Numeric.SpecFunctions.Extra
    Numeric.SpecFunctions.Internal Numeric.Sum

hidden-modules:       Numeric.SpecFunctions.Compat
import-dirs:          /usr/lib/ghc-9.2.8/site-local/math-functions-0.3.4.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/math-functions-0.3.4.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-math-functions
hs-libraries:         HSmath-functions-0.3.4.4-4t3X6AVXtzGCUa2A4nrWTl
depends:
    base-4.16.4.0 data-default-class-0.1.2.0-Kt3ErptCt5hHHi8l61h1Gp
    deepseq-1.4.6.1 primitive-0.7.4.0-I9XTAmFqErC1hXdXvvNzkS
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:
    /usr/share/doc/haskell-math-functions/html/math-functions.haddock

haddock-html:         /usr/share/doc/haskell-math-functions/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

