#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lukko
version:              0.1.1.3
visibility:           public
id:                   lukko-0.1.1.3-K7lTIsJthdhEkX9yNk2wRw
key:                  lukko-0.1.1.3-K7lTIsJthdhEkX9yNk2wRw
license:              GPL-2.0-or-later AND BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
synopsis:             File locking
description:
    This package provides access to platform dependent file locking APIs:

    * <https://www.gnu.org/software/libc/manual/html_node/Open-File-Description-Locks.html Open file descriptor locking> on Linux ("Lukko.OFD")
    * BSD-style @flock(2)@ locks on UNIX platforms ("Lukko.FLock")
    * Windows locking via <https://docs.microsoft.com/en-us/windows/win32/api/fileapi/nf-fileapi-lockfilee LockFileEx> ("Lukko.Windows")
    * No-op locking, which throws exceptions ("Lukko.NoOp")
    * "Lukko" module exports the best option for the target platform with uniform API.

    There are alternative file locking packages:

    * "GHC.IO.Handle.Lock" in @base >= 4.10@ is good enough for most use cases.
    However, uses only '\''Handle'\''s so these locks cannot be used for intra-process locking.
    (You should use e.g. '\''MVar'\'' in addition).

    * <https://hackage.haskell.org/package/filelock filelock> doesn'\''t support OFD locking.

    /Lukko/ means lock in Finnish.

    Submodules "Lukko.OFD", "Lukko.Windows" etc are available based on following conditions.

    @
    if os(windows)
    \  cpp-options: -DHAS_WINDOWS_LOCK

    elif (os(linux) && flag(ofd-locking))
    \  cpp-options: -DHAS_OFD_LOCKING
    \  cpp-options: -DHAS_FLOCK

    elif !(os(solaris) || os(aix))
    \  cpp-options: -DHAS_FLOCK
    @

    "Lukko.FLock" is available on not (Windows or Solaris or AIX).
    "Lukko.NoOp" is always available.

category:             System, Concurrency
abi:                  73037d939a9ae61e0385d8c766dcbad0
exposed:              True
exposed-modules:      Lukko Lukko.FLock Lukko.NoOp Lukko.OFD
hidden-modules:
    Lukko.Internal.FD Lukko.Internal.FillBytes
    Lukko.Internal.HandleToFD Lukko.Internal.Types

import-dirs:          /usr/lib/ghc-9.2.8/site-local/lukko-0.1.1.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lukko-0.1.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lukko
hs-libraries:         HSlukko-0.1.1.3-K7lTIsJthdhEkX9yNk2wRw
depends:              base-4.16.4.0
haddock-interfaces:   /usr/share/doc/haskell-lukko/html/lukko.haddock
haddock-html:         /usr/share/doc/haskell-lukko/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

