#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp
version:              1.4.0.0
visibility:           public
id:                   lsp-1.4.0.0-8dXApAIuDND6HXLw1JAxHy
key:                  lsp-1.4.0.0-8dXApAIuDND6HXLw1JAxHy
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  0b5e5873888c398f7a1d0f601d968326
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.4.0.1-1IuTROwmhnwCUc93docyJC:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-1IuTROwmhnwCUc93docyJC:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.4.0.1-1IuTROwmhnwCUc93docyJC:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.4.0.1-1IuTROwmhnwCUc93docyJC:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.2.8/site-local/lsp-1.4.0.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lsp-1.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp1.4
hs-libraries:         HSlsp-1.4.0.0-8dXApAIuDND6HXLw1JAxHy
depends:
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    async-2.2.5-LvPNzfas2yXKoPkwBBcN3R
    attoparsec-0.14.4-DN7s9Fr9c113K5agmmE0LB base-4.16.4.0
    bytestring-0.11.4.0 containers-0.6.5.1
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS exceptions-0.10.4
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    hslogger-1.3.1.1-JxJreocAl2VHFYNfcs0VVh
    lens-5.2.3-44yRBOAfB7iFMS16KrPjpp
    lsp-types-1.4.0.1-1IuTROwmhnwCUc93docyJC mtl-2.2.2
    network-uri-2.6.4.2-EwAfSnfKix9WHRPnJWEEo
    random-1.2.1.2-3aSfWlsu7xc3wK3TRJn2vY
    scientific-0.3.7.0-7nXcZobZD337Jkf1NR7gHa
    sorted-list-0.2.2.0-FJWsJE3CTdQ9jNb8JMYLXj stm-2.5.0.2 text-1.2.5.0
    time-1.11.1.1 transformers-0.5.6.2
    unliftio-core-0.2.1.0-2wlRerPMhUe3AYGiMsYOzn
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    uuid-1.3.15-3CviI3xieCwKBwBru8112R

haddock-interfaces:   /usr/share/doc/haskell-lsp1.4/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp1.4/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

