#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-test
version:              0.14.1.0
visibility:           public
id:                   lsp-test-0.14.1.0-IxQW7SLQbYuEc7vTs1Hunt
key:                  lsp-test-0.14.1.0-IxQW7SLQbYuEc7vTs1Hunt
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  ce058f3cc630ec75ba972f0ea6621789
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.6.0.0-HhZ6mX8WaNU74nva3O4wpr:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.6.0.0-HhZ6mX8WaNU74nva3O4wpr:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.2.8/site-local/lsp-test-0.14.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lsp-test-0.14.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.14.1.0-IxQW7SLQbYuEc7vTs1Hunt
depends:
    Diff-0.4.1-47RlfWGWXds34vUy9hSQS Glob-0.10.2-IUS0c8yYTOEJSZESSQNsvs
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    aeson-pretty-0.8.10-1w3bzFq1eKcCRjNt7mV0fD
    ansi-terminal-0.11.5-FgXvUwo3mIX2g72exyhUhE
    async-2.2.5-LvPNzfas2yXKoPkwBBcN3R base-4.16.4.0
    bytestring-0.11.4.0 co-log-core-0.3.2.2-9QCpr9Zeb9TL0WHJGe73ys
    conduit-1.3.6-GKnHuzD4Nn6IarMahEfIxq
    conduit-parse-0.2.1.1-JivvAFouNUE5m3QUN11q6J containers-0.6.5.1
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS directory-1.3.6.2
    exceptions-0.10.4 filepath-1.4.2.2
    lens-5.2.3-44yRBOAfB7iFMS16KrPjpp
    lsp-1.6.0.0-Fm3bPcTc1xJ3BY9cZfhboY
    lsp-types-1.6.0.0-HhZ6mX8WaNU74nva3O4wpr mtl-2.2.2
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5 process-1.6.16.0
    some-1.0.5-L5glA67mR8RJufLDsA2lRz text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

