#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ListLike
version:              4.7.8.2
visibility:           public
id:                   ListLike-4.7.8.2-JcoUhQZvBYNGxJk1zaRQ4U
key:                  ListLike-4.7.8.2-JcoUhQZvBYNGxJk1zaRQ4U
license:              BSD-3-Clause
copyright:            Copyright (c) 2007-2008 John Goerzen
maintainer:           David Fox <dsf@seereason.com>, Andreas Abel
author:               John Goerzen
stability:            Stable
homepage:             http://github.com/ddssff/listlike
synopsis:             Generalized support for list-like structures
description:
    Generalized support for list-like structures in Haskell.

    The ListLike module provides a common interface to the various Haskell
    types that are list-like.  Predefined interfaces include standard
    Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
    types can easily be made ListLike instances as well.

    ListLike also provides for String-like types, such as String and
    ByteString, for types that support input and output, and for types that can handle
    infinite lists.

category:             list, string, text, bytestring, vector
abi:                  758cb56f7ff8b54a8cf283e6929e98db
exposed:              True
exposed-modules:
    Data.ListLike Data.ListLike.Base Data.ListLike.CharString
    Data.ListLike.Chars Data.ListLike.DList Data.ListLike.FMList
    Data.ListLike.FoldableLL Data.ListLike.IO Data.ListLike.Instances
    Data.ListLike.String Data.ListLike.Text Data.ListLike.Text.Builder
    Data.ListLike.Text.Text Data.ListLike.Text.TextLazy
    Data.ListLike.UTF8 Data.ListLike.Utils Data.ListLike.Vector
    Data.ListLike.Vector.Generic Data.ListLike.Vector.Storable
    Data.ListLike.Vector.Unboxed Data.ListLike.Vector.Vector

import-dirs:          /usr/lib/ghc-9.2.8/site-local/ListLike-4.7.8.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/ListLike-4.7.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-listlike
hs-libraries:         HSListLike-4.7.8.2-JcoUhQZvBYNGxJk1zaRQ4U
depends:
    array-0.5.4.0 base-4.16.4.0 bytestring-0.11.4.0 containers-0.6.5.1
    deepseq-1.4.6.1 dlist-1.0-HCxoMn9TirQDgPCFxho7O
    fmlist-0.9.4-7uEcqVbpNsVAkMNtPrswyY text-1.2.5.0
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:   /usr/share/doc/haskell-listlike/html/ListLike.haddock
haddock-html:         /usr/share/doc/haskell-listlike/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

