#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lens-family-core
version:              2.1.3
visibility:           public
id:                   lens-family-core-2.1.3-1OBIJmYHsnQ2CJGGRserxu
key:                  lens-family-core-2.1.3-1OBIJmYHsnQ2CJGGRserxu
license:              BSD-3-Clause
copyright:
    Copyright (C) 2012,2013,2014,2017,2018,2019 Russell O'\''Connor

maintainer:           Russell O'\''Connor <roconnor@r6.ca>
author:               Russell O'\''Connor
stability:            experimental
synopsis:             Haskell 2022 Lens Families
description:
    This package provides first class(†) functional references in Van Laarhoven style supporting the following optics:

    * Lenses (view, over)

    * Traversals (toListOf, matching, over)

    * Setters (over)

    * Grates (zipWithOf, under, review)

    * Resetters (under)

    * Adapters (view, review)

    * Grids (toListOf, over / under, review)

    * Prisms (matching, over / under, review)

    * Getters (view)

    * Folders (toListOf)

    * Reviewers (review)

    (†) For optimal first-class support use the @lens-family@ package with rank 2 / rank N polymorphism.
    "Lens.Family.Clone" allows for first-class support of lenses and traversals for those who cannot support rank 2 polymorphism.

category:             Data, Lenses
abi:                  51623d46d353fcd55aa90e82b60ba5b2
exposed:              True
exposed-modules:
    Lens.Family Lens.Family.Clone Lens.Family.State
    Lens.Family.State.Lazy Lens.Family.State.Strict Lens.Family.Stock
    Lens.Family.Unchecked

hidden-modules:
    Lens.Family.Identical Lens.Family.Phantom Lens.Family.State.Zoom

import-dirs:          /usr/lib/ghc-9.2.8/site-local/lens-family-core-2.1.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lens-family-core-2.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lens-family-core
hs-libraries:         HSlens-family-core-2.1.3-1OBIJmYHsnQ2CJGGRserxu
depends:              base-4.16.4.0 containers-0.6.5.1 transformers-0.5.6.2
haddock-interfaces:
    /usr/share/doc/haskell-lens-family-core/html/lens-family-core.haddock

haddock-html:         /usr/share/doc/haskell-lens-family-core/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

