#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 language-javascript
version:              0.7.1.0
visibility:           public
id:                   language-javascript-0.7.1.0-42OGSslP8LgGU9YXXGEGQ5
key:                  language-javascript-0.7.1.0-42OGSslP8LgGU9YXXGEGQ5
license:              BSD-3-Clause
copyright:
    (c) 2010-2015 Alan Zimmerman
    (c) 2015-2019 Erik de Castro Lopo
    (c) 2018      Daniel Gasienica

maintainer:           Erik de Castro Lopo <erikd@mega-nerd.com>
author:               Alan Zimmerman
homepage:             https://github.com/erikd/language-javascript
synopsis:             Parser for JavaScript
description:
    Parses Javascript into an Abstract Syntax Tree (AST).  Initially intended as frontend to hjsmin.

    Note: Version 0.5.0 breaks compatibility with prior versions, the AST has been reworked to allow
    round trip processing of JavaScript.

category:             Language
abi:                  9e5c3735476e83efc28dc9bc600271a8
exposed:              True
exposed-modules:
    Language.JavaScript.Parser Language.JavaScript.Parser.AST
    Language.JavaScript.Parser.Grammar7
    Language.JavaScript.Parser.Lexer Language.JavaScript.Parser.Parser
    Language.JavaScript.Parser.SrcLocation
    Language.JavaScript.Pretty.Printer
    Language.JavaScript.Process.Minify

hidden-modules:
    Language.JavaScript.Parser.LexerUtils
    Language.JavaScript.Parser.ParseError
    Language.JavaScript.Parser.ParserMonad
    Language.JavaScript.Parser.Token

import-dirs:          /usr/lib/ghc-9.2.8/site-local/language-javascript-0.7.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/language-javascript-0.7.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-language-javascript
hs-libraries:         HSlanguage-javascript-0.7.1.0-42OGSslP8LgGU9YXXGEGQ5
depends:
    array-0.5.4.0 base-4.16.4.0
    blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK bytestring-0.11.4.0
    containers-0.6.5.1 mtl-2.2.2 text-1.2.5.0
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX

haddock-interfaces:
    /usr/share/doc/haskell-language-javascript/html/language-javascript.haddock

haddock-html:         /usr/share/doc/haskell-language-javascript/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

