#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 jira-wiki-markup
version:              1.5.1
visibility:           public
id:                   jira-wiki-markup-1.5.1-4rJ6UEiyLH592Hqr6aruIi
key:                  jira-wiki-markup-1.5.1-4rJ6UEiyLH592Hqr6aruIi
license:              MIT
copyright:            © 2019–2023 Albert Krewinkel
maintainer:           tarleb@zeitkraut.de
author:               Albert Krewinkel
homepage:             https://github.com/tarleb/jira-wiki-markup
synopsis:             Handle Jira wiki markup
description:
    Parse jira wiki text into an abstract syntax tree for easy
    transformation to other formats.

category:             Text
abi:                  1cc1575367964b62a8b22966013d72d6
exposed:              True
exposed-modules:
    Text.Jira.Markup Text.Jira.Parser Text.Jira.Parser.Block
    Text.Jira.Parser.Core Text.Jira.Parser.Inline
    Text.Jira.Parser.PlainText Text.Jira.Parser.Shared
    Text.Jira.Printer

import-dirs:          /usr/lib/ghc-9.2.8/site-local/jira-wiki-markup-1.5.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/jira-wiki-markup-1.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-jira-wiki-markup
hs-libraries:         HSjira-wiki-markup-1.5.1-4rJ6UEiyLH592Hqr6aruIi
depends:              base-4.16.4.0 mtl-2.2.2 parsec-3.1.15.0 text-1.2.5.0
haddock-interfaces:
    /usr/share/doc/haskell-jira-wiki-markup/html/jira-wiki-markup.haddock

haddock-html:         /usr/share/doc/haskell-jira-wiki-markup/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

