#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 incremental-parser
version:              0.5.1
visibility:           public
id:                   incremental-parser-0.5.1-oueFa9yS0K3YVfMXl4xYW
key:                  incremental-parser-0.5.1-oueFa9yS0K3YVfMXl4xYW
license:              GPL-3.0-only
copyright:            (c) 2011-2023 Mario Blazevic
maintainer:           blamario@yahoo.com
author:               Mario Blazevic
homepage:             https://github.com/blamario/incremental-parser
synopsis:
    Generic parser library capable of providing partial results from partial input.

description:
    This package defines yet another parser combinator library. This one is implemented using the concept of Brzozowski
    derivatives, tweaked and optimized to work with any monoidal input type. Lists, ByteString, and Text are supported out
    of the box, as well as any other data type for which the monoid-subclasses package defines instances. If the parser
    result is also a monoid, its chunks can be extracted incrementally, before the complete input is parsed.

category:             Parsing
abi:                  706ce240f1a45b762bc8f3caea65dfe6
exposed:              True
exposed-modules:
    Control.Applicative.Monoid Text.ParserCombinators.Incremental
    Text.ParserCombinators.Incremental.LeftBiasedLocal
    Text.ParserCombinators.Incremental.Symmetric

import-dirs:          /usr/lib/ghc-9.2.8/site-local/incremental-parser-0.5.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/incremental-parser-0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-incremental-parser
hs-libraries:         HSincremental-parser-0.5.1-oueFa9yS0K3YVfMXl4xYW
depends:
    base-4.16.4.0 input-parsers-0.3.0.2-2xclPHP4TTU3RAn9C3KyIW
    logict-0.7.1.0-AWbLnb32a0xIZkfbzFeCib
    monoid-subclasses-1.2.5.1-IUsGuMy3hhS81AxKOrfp1G
    parsers-0.12.11-4w44w2Sx6nXCRdG7Ne8XkK
    rank2classes-1.5.3.1-60YMdYDL5YlEQKECx0Q3XW transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-incremental-parser/html/incremental-parser.haddock

haddock-html:         /usr/share/doc/haskell-incremental-parser/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

