#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 HTF
version:              0.15.0.1
visibility:           public
id:                   HTF-0.15.0.1-AEpQDnQtyRs7VnUdxsYCQ4
key:                  HTF-0.15.0.1-AEpQDnQtyRs7VnUdxsYCQ4
license:              LGPL-2.1-only
copyright:            (c) 2005-2023 Stefan Wehr
maintainer:           Stefan Wehr
author:               Stefan Wehr
stability:            Beta
homepage:             https://github.com/skogsbaer/HTF/
synopsis:             The Haskell Test Framework
description:
    The Haskell Test Framework (/HTF/ for short) lets you define and organize unit tests,
    QuickCheck properties,
    and black box tests in an
    easy and convenient way. HTF uses a custom preprocessor that collects
    test definitions automatically.

    HTF produces highly readable output
    for failing test cases: it provides exact file name and line number
    information,
    it colors and pretty prints expected and
    actual results, and it displays a diff highlighting the mismatching parts.

    The documentation of the "Test.Framework.Tutorial" module
    provides a tutorial for HTF. The /sample/ directory in
    the HTF repo provides a good starting point for
    a project using HTF.

category:             Testing
abi:                  456953dc71118fe6b8ca487f5d31319c
exposed:              True
exposed-modules:
    Test.Framework Test.Framework.AssertM Test.Framework.BlackBoxTest
    Test.Framework.HUnitWrapper Test.Framework.History
    Test.Framework.JsonOutput Test.Framework.Location
    Test.Framework.Preprocessor Test.Framework.Pretty
    Test.Framework.PrettyHaskell Test.Framework.QuickCheckWrapper
    Test.Framework.TestInterface Test.Framework.TestManager
    Test.Framework.TestTypes Test.Framework.ThreadPool
    Test.Framework.Tutorial Test.Framework.XmlOutput

hidden-modules:
    Paths_HTF Test.Framework.CmdlineOptions Test.Framework.Colors
    Test.Framework.Diff Test.Framework.Process
    Test.Framework.TestReporter Test.Framework.Utils

import-dirs:          /usr/lib/ghc-9.2.8/site-local/HTF-0.15.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/HTF-0.15.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-htf
hs-libraries:         HSHTF-0.15.0.1-AEpQDnQtyRs7VnUdxsYCQ4
depends:
    Diff-0.4.1-47RlfWGWXds34vUy9hSQS
    HUnit-1.6.2.0-4gkKXmDNQefEQuipMNWISY
    QuickCheck-2.14.3-5Q3LTiKAdB0LFKfPwDt7Ga
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6 array-0.5.4.0 base-4.16.4.0
    base64-bytestring-1.2.1.0-74HkITi20nv2BdJvE3AKcV
    bytestring-0.11.4.0 containers-0.6.5.1
    cpphs-1.20.9.1-1K2ccivGg76HqdQttHm61m directory-1.3.6.2
    haskell-src-1.0.4-AvD9RNVt10bC4XdPzYlUWv
    lifted-base-0.2.3.12-Eg70FOm0hWa5vTPmDqrazt
    monad-control-1.0.3.1-CA1GlfSV3Rl4gDTt4Ny2FB mtl-2.2.2
    old-time-1.1.0.4-Dlc8YwGlkPi2Y3VNXkrOFg pretty-1.1.3.6
    process-1.6.16.0 random-1.2.1.2-3aSfWlsu7xc3wK3TRJn2vY
    regex-compat-0.95.2.1-6r4iKSNuQHkEjgz1ilm8wy text-1.2.5.0
    time-1.11.1.1 unix-2.7.2.2 vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
    xmlgen-0.6.2.2-HT4iWf5CISd1uMkA1cvoOi

haddock-interfaces:   /usr/share/doc/haskell-htf/html/HTF.haddock
haddock-html:         /usr/share/doc/haskell-htf/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

