#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hspec-core
version:              2.10.9
visibility:           public
id:                   hspec-core-2.10.9-7UZJfz0FxYmLCPboRLjl0Q
key:                  hspec-core-2.10.9-7UZJfz0FxYmLCPboRLjl0Q
license:              MIT
copyright:
    (c) 2011-2023 Simon Hengel,
    (c) 2011-2012 Trystan Spangler,
    (c) 2011 Greg Weber

maintainer:           Simon Hengel <sol@typeful.net>
stability:            experimental
homepage:             https://hspec.github.io/
synopsis:             A Testing Framework for Haskell
description:
    This package exposes internal types and functions that can be used to extend Hspec'\''s functionality.

category:             Testing
abi:                  bf308e8eb7a8a5373973b6ace579c293
exposed:              True
exposed-modules:
    Test.Hspec.Core.Format Test.Hspec.Core.Formatters
    Test.Hspec.Core.Formatters.V1 Test.Hspec.Core.Formatters.V2
    Test.Hspec.Core.Hooks Test.Hspec.Core.QuickCheck
    Test.Hspec.Core.Runner Test.Hspec.Core.Spec Test.Hspec.Core.Util

hidden-modules:
    GetOpt.Declarative GetOpt.Declarative.Environment
    GetOpt.Declarative.Interpret GetOpt.Declarative.Types
    GetOpt.Declarative.Util NonEmpty Test.Hspec.Core.Clock
    Test.Hspec.Core.Compat Test.Hspec.Core.Config
    Test.Hspec.Core.Config.Definition Test.Hspec.Core.Config.Options
    Test.Hspec.Core.Example Test.Hspec.Core.Example.Location
    Test.Hspec.Core.FailureReport Test.Hspec.Core.Formatters.Diff
    Test.Hspec.Core.Formatters.Internal
    Test.Hspec.Core.Formatters.Pretty
    Test.Hspec.Core.Formatters.Pretty.Parser
    Test.Hspec.Core.Formatters.Pretty.Parser.Parser
    Test.Hspec.Core.Formatters.Pretty.Unicode
    Test.Hspec.Core.Formatters.V1.Free
    Test.Hspec.Core.Formatters.V1.Monad Test.Hspec.Core.QuickCheckUtil
    Test.Hspec.Core.Runner.Eval Test.Hspec.Core.Runner.JobQueue
    Test.Hspec.Core.Runner.PrintSlowSpecItems
    Test.Hspec.Core.Runner.Result Test.Hspec.Core.Shuffle
    Test.Hspec.Core.Spec.Monad Test.Hspec.Core.Timer
    Test.Hspec.Core.Tree Control.Concurrent.Async Data.Algorithm.Diff
    Paths_hspec_core

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hspec-core-2.10.9
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hspec-core-2.10.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hspec-core
hs-libraries:         HShspec-core-2.10.9-7UZJfz0FxYmLCPboRLjl0Q
depends:
    HUnit-1.6.2.0-4gkKXmDNQefEQuipMNWISY
    QuickCheck-2.14.3-5Q3LTiKAdB0LFKfPwDt7Ga
    ansi-terminal-0.11.5-FgXvUwo3mIX2g72exyhUhE array-0.5.4.0
    base-4.16.4.0 call-stack-0.4.0-kYtciisYfe7TdjBJDTvHP
    deepseq-1.4.6.1 directory-1.3.6.2 filepath-1.4.2.2
    haskell-lexer-1.1.1-K7I6uqCDpmCAWLRFKaxnTu
    hspec-expectations-0.8.3-53KTMpuZLbD4EdixkL29oj process-1.6.16.0
    quickcheck-io-0.2.0-EjCXA1fO1A96kJXrvvPYxB
    random-1.2.1.2-3aSfWlsu7xc3wK3TRJn2vY
    setenv-0.1.1.3-3TgCzb5FKNIC6AFHCaPUY stm-2.5.0.2
    tf-random-0.5-69QFObz7qQuHDk2akm71GF time-1.11.1.1
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-hspec-core/html/hspec-core.haddock
haddock-html:         /usr/share/doc/haskell-hspec-core/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

