#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 HsOpenSSL
version:              0.11.7.8
visibility:           public
id:                   HsOpenSSL-0.11.7.8-YquDGNdxAZ7e16Ec2PvZH
key:                  HsOpenSSL-0.11.7.8-YquDGNdxAZ7e16Ec2PvZH
license:              LicenseRef-PublicDomain
maintainer:           Vladimir Shabanov <dev@vshabanov.com>
author:               Adam Langley, Mikhail Vorozhtsov, PHO, Taru Karttunen
stability:            stable
homepage:             https://github.com/haskell-cryptography/HsOpenSSL
synopsis:             Partial OpenSSL binding for Haskell
description:
    HsOpenSSL is an OpenSSL binding for Haskell. It can generate RSA
    and DSA keys, read and write PEM files, generate message digests,
    sign and verify messages, encrypt and decrypt messages. It has
    also some capabilities of creating SSL clients and servers.

    This package is in production use by a number of Haskell based
    systems and stable. You may also be interested in the @tls@ package,
    <http://hackage.haskell.org/package/tls>, which is a pure Haskell
    implementation of SSL.

category:             Cryptography
abi:                  5d47f616147112aff1d195e347b5c32e
exposed:              True
exposed-modules:
    OpenSSL OpenSSL.BN OpenSSL.Cipher OpenSSL.DER OpenSSL.DH
    OpenSSL.DSA OpenSSL.EVP.Base64 OpenSSL.EVP.Cipher
    OpenSSL.EVP.Digest OpenSSL.EVP.Internal OpenSSL.EVP.Open
    OpenSSL.EVP.PKey OpenSSL.EVP.Seal OpenSSL.EVP.Sign
    OpenSSL.EVP.Verify OpenSSL.PEM OpenSSL.PKCS7 OpenSSL.RSA
    OpenSSL.Random OpenSSL.Session OpenSSL.X509 OpenSSL.X509.Request
    OpenSSL.X509.Revocation OpenSSL.X509.Store

hidden-modules:
    OpenSSL.ASN1 OpenSSL.BIO OpenSSL.ERR OpenSSL.Objects
    OpenSSL.SSL.Option OpenSSL.Stack OpenSSL.Utils OpenSSL.X509.Name
    OpenSSL.DH.Internal

import-dirs:          /usr/lib/ghc-9.2.8/site-local/HsOpenSSL-0.11.7.8
library-dirs:         /usr/lib/ghc-9.2.8/site-local/HsOpenSSL-0.11.7.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hsopenssl
hs-libraries:         HSHsOpenSSL-0.11.7.8-YquDGNdxAZ7e16Ec2PvZH
extra-libraries:      ssl crypto
includes:             openssl/asn1.h
depends:
    base-4.16.4.0 bytestring-0.11.4.0
    network-3.1.4.0-I7hY9PROidqFfCvyq23hqh time-1.11.1.1

haddock-interfaces:   /usr/share/doc/haskell-hsopenssl/html/HsOpenSSL.haddock
haddock-html:         /usr/share/doc/haskell-hsopenssl/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

