#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hOpenPGP
version:              2.9.8
visibility:           public
id:                   hOpenPGP-2.9.8-6z5eXNHb9IPEkSv941IPzV
key:                  hOpenPGP-2.9.8-6z5eXNHb9IPEkSv941IPzV
license:              MIT
copyright:            2012-2022  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  134e1cc85287c00f9df7fdf4b39c2521
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hOpenPGP-2.9.8
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hOpenPGP-2.9.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.9.8-6z5eXNHb9IPEkSv941IPzV
depends:
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    asn1-encoding-0.9.6-DRY3PLtkyAQ5Jk08Z3s25d
    attoparsec-0.14.4-DN7s9Fr9c113K5agmmE0LB base-4.16.4.0
    base16-bytestring-1.0.2.0-E91HY5tPsI5AcRTlaN47xj
    bifunctors-5.6-24PtXDCU2m5EbKOhSIeuUk binary-0.8.9.0
    binary-conduit-1.3.1-5GBogotxCCA7Bp4DcMtFoq bytestring-0.11.4.0
    bz2-1.0.1.1-3kLnpelj2T74P5lRqXKc5i
    conduit-1.3.6-GKnHuzD4Nn6IarMahEfIxq
    conduit-extra-1.3.6-DF8DOiU714JCf1u0kSL4TS containers-0.6.5.1
    crypto-cipher-types-0.0.9-JlEUy6YMnlQJGxVQmgyp8z
    cryptonite-0.30-5ffgsU93G6qEHPdP7zDBYF
    errors-2.3.0-Ckn5Q8EufG4IUjWXCt9PJH
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    incremental-parser-0.5.1-oueFa9yS0K3YVfMXl4xYW
    ixset-typed-0.5.1.0-7I1gjysqeIuHqy2QvdWQAI
    lens-5.2.3-44yRBOAfB7iFMS16KrPjpp
    memory-0.18.0-Hvum6HaH78UJG59LYyNLK1
    monad-loops-0.4.3-1PoLx7GFY2f6JjKzBe0o6E
    nettle-0.3.1.1-IesfSaYKwdg21K60p9ny7B
    network-uri-2.6.4.2-EwAfSnfKix9WHRPnJWEEo
    openpgp-asciiarmor-0.1.2-6BtIphA4CAK3xh7sQP8GTu
    prettyprinter-1.7.1-JEDC7ONR1vQJETgOTWpLZ0
    resourcet-1.2.6-AIugU9tehxw9mXWKxKfb0b
    split-0.2.5-Gzu4NbNnTUj6rs5DfMztSh text-1.2.5.0 time-1.11.1.1
    time-locale-compat-0.1.1.5-LoE3V3We7KBAnFwKjT98C2
    transformers-0.5.6.2 unliftio-core-0.2.1.0-2wlRerPMhUe3AYGiMsYOzn
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    zlib-0.6.3.0-3hvuMBy4V96vMim3ALKcj

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

