#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 happstack-server
version:              7.9.2.1
visibility:           public
id:                   happstack-server-7.9.2.1-D6izdwAsjMGKTeCD2lQgeO
key:                  happstack-server-7.9.2.1-D6izdwAsjMGKTeCD2lQgeO
license:              BSD-3-Clause
maintainer:           Happstack team <happs@googlegroups.com>
author:               Happstack team, HAppS LLC
homepage:             http://happstack.com
synopsis:             Web related tools and services.
description:
    Happstack Server provides an HTTP server and a rich set of functions for routing requests, handling query parameters, generating responses, working with cookies, serving files, and more. For in-depth documentation see the Happstack Crash Course <http://happstack.com/docs/crashcourse/index.html>

category:             Web, Happstack
abi:                  706041aeaee7dbfbf501cedf99e9bfc2
exposed:              True
exposed-modules:
    Happstack.Server Happstack.Server.Auth Happstack.Server.Compression
    Happstack.Server.Cookie Happstack.Server.Error
    Happstack.Server.FileServe
    Happstack.Server.FileServe.BuildingBlocks Happstack.Server.I18N
    Happstack.Server.Internal.Compression
    Happstack.Server.Internal.Cookie Happstack.Server.Internal.Handler
    Happstack.Server.Internal.Listen
    Happstack.Server.Internal.LogFormat
    Happstack.Server.Internal.LowLevel
    Happstack.Server.Internal.MessageWrap
    Happstack.Server.Internal.Monads
    Happstack.Server.Internal.Multipart
    Happstack.Server.Internal.RFC822Headers
    Happstack.Server.Internal.Socket
    Happstack.Server.Internal.TimeoutIO
    Happstack.Server.Internal.TimeoutManager
    Happstack.Server.Internal.TimeoutSocket
    Happstack.Server.Internal.Types Happstack.Server.Monads
    Happstack.Server.Response Happstack.Server.Routing
    Happstack.Server.RqData Happstack.Server.SURI
    Happstack.Server.SimpleHTTP Happstack.Server.Types
    Happstack.Server.Validation

hidden-modules:
    Happstack.Server.Internal.Clock Happstack.Server.Internal.LazyLiner
    Happstack.Server.SURI.ParseURI Paths_happstack_server

import-dirs:          /usr/lib/ghc-9.2.8/site-local/happstack-server-7.9.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/happstack-server-7.9.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-happstack-server
hs-libraries:         HShappstack-server-7.9.2.1-D6izdwAsjMGKTeCD2lQgeO
depends:
    base-4.16.4.0 base64-bytestring-1.2.1.0-74HkITi20nv2BdJvE3AKcV
    blaze-html-0.9.2.0-ARMUh31ndZFLabXVs8gk0N bytestring-0.11.4.0
    containers-0.6.5.1 directory-1.3.6.2 exceptions-0.10.4
    extensible-exceptions-0.1.1.4-D8VRIfPBfkhEPmMrxbU9lA
    filepath-1.4.2.2 hslogger-1.3.1.1-JxJreocAl2VHFYNfcs0VVh
    html-1.0.1.2-1i34Da0w7lMJxSeIv8hoxf
    monad-control-1.0.3.1-CA1GlfSV3Rl4gDTt4Ny2FB mtl-2.2.2
    network-3.1.4.0-I7hY9PROidqFfCvyq23hqh
    network-uri-2.6.4.2-EwAfSnfKix9WHRPnJWEEo
    old-locale-1.0.0.7-DSFeUNZwxUU2YUIlh1bsq7 parsec-3.1.15.0
    process-1.6.16.0 sendfile-0.7.11.6-IWHKdp1hx4lInvpO7K2g2l
    syb-0.7.2.4-96PLGA9ePRoKEvwVQEltSr
    system-filepath-0.4.14-By0HrSXnQZ584ycUZKbtPy text-1.2.5.0
    threads-0.5.1.8-7TIgnT4pfYjEmNlbcyXBfy time-1.11.1.1
    transformers-0.5.6.2 transformers-base-0.4.6-Jo7hBiquY6Q1je3XsS9imU
    transformers-compat-0.7.2-9ApmiRwA3hS7UuQpOomcS unix-2.7.2.2
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX xhtml-3000.2.2.1
    zlib-0.6.3.0-3hvuMBy4V96vMim3ALKcj

haddock-interfaces:
    /usr/share/doc/haskell-happstack-server/html/happstack-server.haddock

haddock-html:         /usr/share/doc/haskell-happstack-server/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

