#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hackage-db
version:              2.1.3
visibility:           public
id:                   hackage-db-2.1.3-9s3n6p14WaA9g0hu4MzyR2
key:                  hackage-db-2.1.3-9s3n6p14WaA9g0hu4MzyR2
license:              BSD-3-Clause
maintainer:           sternenseemann <sternenseemann@systemli.org>
author:               Peter Simons, Alexander Altman, Ben James, Kevin Quick
homepage:
    https://github.com/NixOS/cabal2nix/tree/master/hackage-db#readme

synopsis:             Access cabal-install'\''s Hackage database via Data.Map
description:
    This library provides convenient access to the local copy of the Hackage
    database that \"cabal update\" creates. Check out
    <https://github.com/NixOS/hackage-db/tree/master/example/> for a collection
    of simple example programs that demonstrate how to use this code.

category:             Distribution
abi:                  f6329669153be9b587f5190c778f5afa
exposed:              True
exposed-modules:
    Distribution.Hackage.DB Distribution.Hackage.DB.Builder
    Distribution.Hackage.DB.Errors Distribution.Hackage.DB.MetaData
    Distribution.Hackage.DB.Parsed Distribution.Hackage.DB.Path
    Distribution.Hackage.DB.Unparsed Distribution.Hackage.DB.Utility

hidden-modules:       Paths_hackage_db
import-dirs:          /usr/lib/ghc-9.2.8/site-local/hackage-db-2.1.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hackage-db-2.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hackage-db
hs-libraries:         HShackage-db-2.1.3-9s3n6p14WaA9g0hu4MzyR2
depends:
    Cabal-3.6.3.0 aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6 base-4.16.4.0
    bytestring-0.11.4.0 containers-0.6.5.1 directory-1.3.6.2
    exceptions-0.10.4 filepath-1.4.2.2
    tar-0.5.1.1-FV3imbTuzBiF8SlOSs8JNH time-1.11.1.1
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX

haddock-interfaces:   /usr/share/doc/haskell-hackage-db/html/hackage-db.haddock
haddock-html:         /usr/share/doc/haskell-hackage-db/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

