#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 equivalence
version:              0.4.1
visibility:           public
id:                   equivalence-0.4.1-9vxvWEupSzu9na6J8QIP1g
key:                  equivalence-0.4.1-9vxvWEupSzu9na6J8QIP1g
license:              BSD-3-Clause
maintainer:           Andreas Abel
author:               Patrick Bahr
stability:            provisional
homepage:             https://github.com/pa-ba/equivalence
synopsis:
    Maintaining an equivalence relation implemented as union-find using STT.

description:
    This is an implementation of Tarjan'\''s Union-Find algorithm (Robert
    E. Tarjan. "Efficiency of a Good But Not Linear Set Union
    Algorithm", JACM 22(2), 1975) in order to maintain an equivalence
    relation.
    This implementation is a port of the /union-find/ package using the
    ST monad transformer (instead of the IO monad).

category:             Algorithms, Data
abi:                  ecff39897d4f04c63c2fdff623e602fc
exposed:              True
exposed-modules:      Data.Equivalence.Monad Data.Equivalence.STT
import-dirs:          /usr/lib/ghc-9.2.8/site-local/equivalence-0.4.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/equivalence-0.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-equivalence
hs-libraries:         HSequivalence-0.4.1-9vxvWEupSzu9na6J8QIP1g
depends:
    STMonadTrans-0.4.8-89Dr6Zue5rHlYiayyPXyW base-4.16.4.0
    containers-0.6.5.1 mtl-2.2.2 transformers-0.5.6.2
    transformers-compat-0.7.2-9ApmiRwA3hS7UuQpOomcS

haddock-interfaces:   /usr/share/doc/haskell-equivalence/html/equivalence.haddock
haddock-html:         /usr/share/doc/haskell-equivalence/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

