#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dbus
version:              1.3.1
visibility:           public
id:                   dbus-1.3.1-5apRNJ1dHOxDcvT8Ipj3eQ
key:                  dbus-1.3.1-5apRNJ1dHOxDcvT8Ipj3eQ
license:              Apache-2.0
maintainer:           Andrey Sverdlichenko <blaze@ruddy.ru>
author:               John Millikin <john@john-millikin.com>
stability:            experimental
homepage:             https://github.com/rblaze/haskell-dbus#readme
synopsis:             A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.

    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.

    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.

    Example: connect to the session bus, and get a list of active names.

    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;

    import Data.List (sort)
    import DBus
    import DBus.Client

    main = do
    &#x20;   client <- connectSession
    &#x20;
    &#x20;   -- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;
    &#x20;   -- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   -- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;
    &#x20;   -- Print each name on a line, sorted so reserved names are below
    &#x20;   -- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @

    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver

category:             Network, Desktop
abi:                  da3077e87ccaa62d83d5ea40dc311f2c
exposed:              True
exposed-modules:
    DBus DBus.Client DBus.Generation DBus.Internal.Address
    DBus.Internal.Message DBus.Internal.Types DBus.Internal.Wire
    DBus.Introspection DBus.Introspection.Parse
    DBus.Introspection.Render DBus.Introspection.Types DBus.Socket
    DBus.TH DBus.Transport

import-dirs:          /usr/lib/ghc-9.2.8/site-local/dbus-1.3.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/dbus-1.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-dbus
hs-libraries:         HSdbus-1.3.1-5apRNJ1dHOxDcvT8Ipj3eQ
depends:
    base-4.16.4.0 bytestring-0.11.4.0
    cereal-0.5.8.3-9zcITCTkqXtHoa6jbeSF22
    conduit-1.3.6-GKnHuzD4Nn6IarMahEfIxq containers-0.6.5.1
    deepseq-1.4.6.1 exceptions-0.10.4 filepath-1.4.2.2
    lens-5.2.3-44yRBOAfB7iFMS16KrPjpp
    network-3.1.4.0-I7hY9PROidqFfCvyq23hqh parsec-3.1.15.0
    random-1.2.1.2-3aSfWlsu7xc3wK3TRJn2vY
    split-0.2.5-Gzu4NbNnTUj6rs5DfMztSh template-haskell-2.18.0.0
    text-1.2.5.0 th-lift-0.8.4-7yLYwH7OaPD4aJs3FpHkYY
    transformers-0.5.6.2 unix-2.7.2.2
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
    xml-conduit-1.9.1.4-6X2DGMUptWqJTYDzgF6m6x
    xml-types-0.3.8-LZyzf9bLT8K9kdiyyQ9IUF

haddock-interfaces:   /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html:         /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

