#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 curve25519
version:              0.2.8
visibility:           public
id:                   curve25519-0.2.8-DXIRAiJ69CRI7DvLqUyhaY
key:                  curve25519-0.2.8-DXIRAiJ69CRI7DvLqUyhaY
license:              BSD-3-Clause
maintainer:           Adam Wick <awick@uhsure.com>
author:               Adam Wick <awick@uhsure.com>
homepage:             http://github.com/acw/curve25519
synopsis:
    Fast implementations of the curve25519 elliptic curve primitives.

description:
    Haskell bindings and extensions to the curve25519-donna
    codebase. This module is a pretty straightforward implementation
    of the basic cryptographic routines you'\''d want from a project that
    uses curve25519: key generation, and key agreement. For further
    functionality, you'\''ll want to look elsewhere.

category:             Math
abi:                  986e3d7e60f60f0c001038994c2473d0
exposed:              True
exposed-modules:
    Crypto.Curve25519 Crypto.Curve25519.Exceptions
    Crypto.Curve25519.Pure

import-dirs:          /usr/lib/ghc-9.2.8/site-local/curve25519-0.2.8
library-dirs:         /usr/lib/ghc-9.2.8/site-local/curve25519-0.2.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-curve25519
hs-libraries:         HScurve25519-0.2.8-DXIRAiJ69CRI7DvLqUyhaY
depends:
    base-4.16.4.0 bytestring-0.11.4.0
    crypto-api-0.13.3-95IFBy4WvL6L3p6UFm5MLc

haddock-interfaces:   /usr/share/doc/haskell-curve25519/html/curve25519.haddock
haddock-html:         /usr/share/doc/haskell-curve25519/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

