#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 crypto-enigma
version:              0.1.1.6
visibility:           public
id:                   crypto-enigma-0.1.1.6-HnD5L2ux5hLGAVrXY2Hef9
key:                  crypto-enigma-0.1.1.6-HnD5L2ux5hLGAVrXY2Hef9
license:              BSD-3-Clause
copyright:            (c) 2014-2019 Roy Levien
maintainer:           royl@aldaron.com
author:               Roy Levien
homepage:             https://github.com/orome/crypto-enigma-hs
synopsis:             An Enigma machine simulator with display. 
description:
    The crypto-enigma package is an Enigma machine simulator
    with rich display and machine state details.

    Currently support is only provided for the machine models in most widespread general use
    during the war years: the I, M3, and M4.

    For basic functionality, including some introspection of machine state
    and the mappings performed, simply

    > > import Crypto.Enigma

    For richer display functionality additionally

    > > import Crypto.Enigma.Display

    (Note that this package assumes support for combining Unicode, without which some output may
    appear garbled.)

category:             Cryptography, Education
abi:                  714ef17c283894fe731d3d399169dc0d
exposed:              True
exposed-modules:      Crypto.Enigma Crypto.Enigma.Display
hidden-modules:       Crypto.Enigma.Utils
import-dirs:          /usr/lib/ghc-9.2.8/site-local/crypto-enigma-0.1.1.6
library-dirs:         /usr/lib/ghc-9.2.8/site-local/crypto-enigma-0.1.1.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-crypto-enigma
hs-libraries:         HScrypto-enigma-0.1.1.6-HnD5L2ux5hLGAVrXY2Hef9
depends:
    base-4.16.4.0 containers-0.6.5.1 split-0.2.5-Gzu4NbNnTUj6rs5DfMztSh
    text-1.2.5.0

haddock-interfaces:
    /usr/share/doc/haskell-crypto-enigma/html/crypto-enigma.haddock

haddock-html:         /usr/share/doc/haskell-crypto-enigma/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

