#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 crypto-api
version:              0.13.3
visibility:           public
id:                   crypto-api-0.13.3-95IFBy4WvL6L3p6UFm5MLc
key:                  crypto-api-0.13.3-95IFBy4WvL6L3p6UFm5MLc
license:              BSD-3-Clause
copyright:            Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer:           Thomas DuBuisson <thomas.dubuisson@gmail.com>
author:
    Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)

stability:            stable
homepage:             https://github.com/TomMD/crypto-api
synopsis:             A generic interface for cryptographic operations
description:
    A generic interface for cryptographic operations (hashes, ciphers, randomness).
    Maintainers of hash and cipher implementations are
    encouraged to add instances for the classes defined
    in Crypto.Classes.  Crypto users are similarly
    encouraged to use the interfaces defined in the Classes
    module.
    Any concepts or functions of general use to more than
    one cryptographic algorithm (ex: padding) is within
    scope of this package.

category:             Data, Cryptography
abi:                  de57da82eb3b03842e5d950e18fa112b
exposed:              True
exposed-modules:
    Crypto.Classes Crypto.Classes.Exceptions Crypto.HMAC Crypto.Modes
    Crypto.Padding Crypto.Random Crypto.Types Crypto.Util

hidden-modules:       Crypto.CPoly
import-dirs:          /usr/lib/ghc-9.2.8/site-local/crypto-api-0.13.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/crypto-api-0.13.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-crypto-api
hs-libraries:         HScrypto-api-0.13.3-95IFBy4WvL6L3p6UFm5MLc
depends:
    base-4.16.4.0 bytestring-0.11.4.0
    cereal-0.5.8.3-9zcITCTkqXtHoa6jbeSF22
    entropy-0.4.1.10-C5y4ZMubclPFkOssafbGqV
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-crypto-api/html/crypto-api.haddock
haddock-html:         /usr/share/doc/haskell-crypto-api/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

