#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-prelude
version:              1.8.1
visibility:           public
id:                   clash-prelude-1.8.1-41E4hXtAOMz9081GK1Dl0g
key:                  clash-prelude-1.8.1-41E4hXtAOMz9081GK1Dl0g
license:              BSD-2-Clause
copyright:
    Copyright © 2013-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.,
    2021-2023, QBayLogic B.V.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - Prelude library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Prelude library containing datatypes and functions for circuit design

    To use the library:

    * Import "Clash.Prelude"

    * Alternatively, if you want to explicitly route clock and reset ports,
    for more straightforward multi-clock designs, you can import the
    "Clash.Explicit.Prelude" module. Note that you should not import
    "Clash.Prelude" and "Clash.Explicit.Prelude" at the same time as they
    have overlapping definitions.

    A preliminary version of a tutorial can be found in "Clash.Tutorial", for a
    general overview of the library you should however check out "Clash.Prelude".
    Some circuit examples can be found in "Clash.Examples".

category:             Hardware
abi:                  baf9356e1c80db83e52b0f02bcb57044
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation
    Clash.Annotations.BitRepresentation.Deriving
    Clash.Annotations.BitRepresentation.Internal
    Clash.Annotations.BitRepresentation.Util
    Clash.Annotations.Primitive Clash.Annotations.SynthesisAttributes
    Clash.Annotations.TH Clash.Annotations.TopEntity
    Clash.Class.AutoReg Clash.Class.AutoReg.Internal
    Clash.Class.BitPack Clash.Class.BitPack.BitIndex
    Clash.Class.BitPack.BitReduction Clash.Class.BitPack.Internal
    Clash.Class.BitPack.Internal.TH Clash.Class.Counter
    Clash.Class.Counter.Internal Clash.Class.Counter.TH Clash.Class.Exp
    Clash.Class.HasDomain Clash.Class.HasDomain.CodeGen
    Clash.Class.HasDomain.Common Clash.Class.HasDomain.HasSingleDomain
    Clash.Class.HasDomain.HasSpecificDomain Clash.Class.Num
    Clash.Class.Parity Clash.Class.Resize Clash.Clocks Clash.Examples
    Clash.Examples.Internal Clash.Explicit.BlockRam
    Clash.Explicit.BlockRam.Blob Clash.Explicit.BlockRam.File
    Clash.Explicit.BlockRam.Internal Clash.Explicit.BlockRam.Model
    Clash.Explicit.DDR Clash.Explicit.Mealy Clash.Explicit.Moore
    Clash.Explicit.Prelude Clash.Explicit.Prelude.Safe
    Clash.Explicit.RAM Clash.Explicit.ROM Clash.Explicit.ROM.Blob
    Clash.Explicit.ROM.File Clash.Explicit.Reset Clash.Explicit.Signal
    Clash.Explicit.Signal.Delayed Clash.Explicit.SimIO
    Clash.Explicit.Synchronizer Clash.Explicit.Testbench
    Clash.Explicit.Verification Clash.HaskellPrelude Clash.Hidden
    Clash.Intel.ClockGen Clash.Intel.DDR Clash.Magic Clash.NamedTypes
    Clash.Num.Erroring Clash.Num.Overflowing Clash.Num.Saturating
    Clash.Num.Wrapping Clash.Num.Zeroing Clash.Prelude
    Clash.Prelude.BlockRam Clash.Prelude.BlockRam.Blob
    Clash.Prelude.BlockRam.File Clash.Prelude.DataFlow
    Clash.Prelude.Mealy Clash.Prelude.Moore Clash.Prelude.RAM
    Clash.Prelude.ROM Clash.Prelude.ROM.Blob Clash.Prelude.ROM.File
    Clash.Prelude.Safe Clash.Prelude.Testbench Clash.Promoted.Nat
    Clash.Promoted.Nat.Literals Clash.Promoted.Nat.TH
    Clash.Promoted.Nat.Unsafe Clash.Promoted.Symbol Clash.Signal
    Clash.Signal.BiSignal Clash.Signal.Bundle Clash.Signal.Delayed
    Clash.Signal.Delayed.Bundle Clash.Signal.Delayed.Internal
    Clash.Signal.Internal Clash.Signal.Internal.Ambiguous
    Clash.Signal.Trace Clash.Sized.BitVector Clash.Sized.Fixed
    Clash.Sized.Index Clash.Sized.Internal.BitVector
    Clash.Sized.Internal.Index Clash.Sized.Internal.Mod
    Clash.Sized.Internal.Signed Clash.Sized.Internal.Unsigned
    Clash.Sized.RTree Clash.Sized.Signed Clash.Sized.Unsigned
    Clash.Sized.Vector Clash.Tutorial Clash.Verification
    Clash.Verification.DSL Clash.Verification.Internal Clash.XException
    Clash.XException.Internal Clash.XException.MaybeX
    Clash.XException.TH Clash.Xilinx.ClockGen Clash.Xilinx.DDR

hidden-modules:
    Clash.Class.AutoReg.Instances Clash.Clocks.Internal Clash.CPP
    Clash.Signal.Bundle.Internal Language.Haskell.TH.Compat
    Paths_clash_prelude

import-dirs:          /usr/lib/ghc-9.2.8/site-local/clash-prelude-1.8.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/clash-prelude-1.8.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-prelude
hs-libraries:         HSclash-prelude-1.8.1-41E4hXtAOMz9081GK1Dl0g
depends:
    QuickCheck-2.14.3-5Q3LTiKAdB0LFKfPwDt7Ga array-0.5.4.0
    arrows-0.4.4.2-HNS5YXTGcKy2xvWrv7SYmR base-4.16.4.0 binary-0.8.9.0
    bytestring-0.11.4.0 constraints-0.13.4-4Q14INZ7ZVkatQu3RBbgf
    containers-0.6.5.1 data-binary-ieee754-0.4.4-5RBO9sqtqwKK43ihLnlB61
    data-default-class-0.1.2.0-Kt3ErptCt5hHHi8l61h1Gp deepseq-1.4.6.1
    extra-1.7.16-KR1Y4egVNjKBcN1wDcWpKS ghc-bignum-1.2 ghc-prim-0.8.0
    ghc-typelits-extra-0.4.4-6xIu1Ago2XyIAgD5onxg2Y
    ghc-typelits-knownnat-0.7.8-72upV0krxdIFLIkylNGBCR
    ghc-typelits-natnormalise-0.7.8-D5oe1a9K8d0Cxo5TzHYEe1
    half-0.3.1-IptsrnsqsMaJKU0FfRAFm8
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    infinite-list-0.1.1-LEd3fguMvDM1p9smcTO0gD
    lens-5.2.3-44yRBOAfB7iFMS16KrPjpp mtl-2.2.2
    recursion-schemes-5.2.3-H8lMcvyyeZq6hqUpHrFEoc
    reflection-2.1.8-9l3sIaZb1RMHSXHv6B9bNo
    singletons-3.0.3-Io3hehq6qbkDYlAqbzjjPX
    string-interpolate-0.3.4.0-Aesh2yn18mKAzk77VJOf7W
    template-haskell-2.18.0.0 text-1.2.5.0
    th-abstraction-0.4.5.0-FQrzhXbdvQX3Z0wTw3euNu
    th-lift-0.8.4-7yLYwH7OaPD4aJs3FpHkYY
    th-orphans-0.13.14-GNCm5mNtIsCKjq0nzifpE1 time-1.11.1.1
    transformers-0.5.6.2 type-errors-0.2.0.2-9Jbi7ea2WTGG5bm9xvDm8U
    uniplate-1.6.13-AjSqydB1rb24oLC5xoUisy
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:
    /usr/share/doc/haskell-clash-prelude/html/clash-prelude.haddock

haddock-html:         /usr/share/doc/haskell-clash-prelude/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

