#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cassava
version:              0.5.3.2
visibility:           public
id:                   cassava-0.5.3.2-4IeZhHac9nh8sMxy4aGJWW
key:                  cassava-0.5.3.2-4IeZhHac9nh8sMxy4aGJWW
license:              BSD-3-Clause
copyright:
    (c) 2012 Johan Tibell
    (c) 2012 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           https://github.com/haskell-hvr/cassava
author:               Johan Tibell
homepage:             https://github.com/haskell-hvr/cassava
synopsis:             A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.

    @cassava@'\''s API includes support for

    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")

    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:

    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"

    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.

category:             Text, Web, CSV
abi:                  c20cfd77f7838457f7f835ec3ef41d34
exposed:              True
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming

hidden-modules:
    Data.Csv.Conversion Data.Csv.Conversion.Internal Data.Csv.Encoding
    Data.Csv.Types Data.Csv.Util

import-dirs:          /usr/lib/ghc-9.2.8/site-local/cassava-0.5.3.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/cassava-0.5.3.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cassava
hs-libraries:         HScassava-0.5.3.2-4IeZhHac9nh8sMxy4aGJWW
depends:
    Only-0.1-DiaFlOQSZ1l8JCg8TmCabZ array-0.5.4.0
    attoparsec-0.14.4-DN7s9Fr9c113K5agmmE0LB base-4.16.4.0
    bytestring-0.11.4.0 containers-0.6.5.1 deepseq-1.4.6.1
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    scientific-0.3.7.0-7nXcZobZD337Jkf1NR7gHa text-1.2.5.0
    text-short-0.1.6-7dqeCbTHeH0F2s6oD6Dpcz transformers-0.5.6.2
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:   /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html:         /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

