#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cairo
version:              0.13.10.0
visibility:           public
id:                   cairo-0.13.10.0-EJUlZG10lya39crLtwrymC
key:                  cairo-0.13.10.0-EJUlZG10lya39crLtwrymC
license:              BSD-3-Clause
copyright:
    (c) 2001-2010 The Gtk2Hs Team, (c) Paolo Martini 2005, (c) Abraham Egnor 2003, 2004, (c) Aetion Technologies LLC 2004

maintainer:           gtk2hs-users@lists.sourceforge.net
author:               Axel Simon, Duncan Coutts
stability:            stable
homepage:             http://projects.haskell.org/gtk2hs/
synopsis:             Binding to the Cairo library.
description:
    Cairo is a library to render high quality vector graphics. There
    exist various backends that allows rendering to Gtk windows, PDF,
    PS, PNG and SVG documents, amongst others.

category:             Graphics
abi:                  fca285fd0da33cc06f1b658008292d6e
exposed:              True
exposed-modules:
    Graphics.Rendering.Cairo Graphics.Rendering.Cairo.Internal
    Graphics.Rendering.Cairo.Matrix Graphics.Rendering.Cairo.Types

hidden-modules:
    Graphics.Rendering.Cairo.Internal.Drawing.Cairo
    Graphics.Rendering.Cairo.Internal.Drawing.Paths
    Graphics.Rendering.Cairo.Internal.Drawing.Patterns
    Graphics.Rendering.Cairo.Internal.Drawing.Text
    Graphics.Rendering.Cairo.Internal.Drawing.Transformations
    Graphics.Rendering.Cairo.Internal.Fonts.FontOptions
    Graphics.Rendering.Cairo.Internal.Surfaces.Image
    Graphics.Rendering.Cairo.Internal.Surfaces.PNG
    Graphics.Rendering.Cairo.Internal.Surfaces.Surface
    Graphics.Rendering.Cairo.Internal.Utilities
    Graphics.Rendering.Cairo.Internal.Surfaces.PDF
    Graphics.Rendering.Cairo.Internal.Surfaces.PS
    Graphics.Rendering.Cairo.Internal.Surfaces.SVG
    Graphics.Rendering.Cairo.Internal.Region

import-dirs:          /usr/lib/ghc-9.2.8/site-local/cairo-0.13.10.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/cairo-0.13.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cairo
hs-libraries:         HScairo-0.13.10.0-EJUlZG10lya39crLtwrymC
extra-libraries:      z cairo png16
include-dirs:
    /usr/include/cairo /usr/include/freetype2 /usr/include/harfbuzz
    /usr/include/glib-2.0 /usr/lib/glib-2.0/include
    /usr/include/sysprof-6 /usr/include/pixman-1 /usr/include/libpng16

depends:
    array-0.5.4.0 base-4.16.4.0 bytestring-0.11.4.0 mtl-2.2.2
    text-1.2.5.0 utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX

haddock-interfaces:   /usr/share/doc/haskell-cairo/html/cairo.haddock
haddock-html:         /usr/share/doc/haskell-cairo/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

