#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 brick
version:              0.71.1
visibility:           public
id:                   brick-0.71.1-JbQCznK5dLZAh7XaGqJq9l
key:                  brick-0.71.1-JbQCznK5dLZAh7XaGqJq9l
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2022
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  4a520e53abc62c1cfbfb20a74c177dee
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Main Brick.Themes Brick.Types Brick.Util
    Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.Internal
    Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.2.8/site-local/brick-0.71.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/brick-0.71.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick0.71
hs-libraries:         HSbrick-0.71.1-JbQCznK5dLZAh7XaGqJq9l
depends:
    base-4.16.4.0 bytestring-0.11.4.0
    config-ini-0.2.6.0-K0emvoVXvOmGy9cR1wMnio containers-0.6.5.1
    contravariant-1.5.5-6oWUjmJNxDBFhugVD5s9dq
    data-clist-0.2-ETxEfUTw9Px2srgj1Z13FN deepseq-1.4.6.1
    directory-1.3.6.2 dlist-1.0-HCxoMn9TirQDgPCFxho7O exceptions-0.10.4
    filepath-1.4.2.2 microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA
    microlens-mtl-0.2.0.3-K2j2D46quth4CyQpetHsMp
    microlens-th-0.4.3.15-BttKu46tg2TPgxEFeI4m6 stm-2.5.0.2
    template-haskell-2.18.0.0 text-1.2.5.0
    text-zipper-0.13-K8U9UU22RJ5GMcc8Glpqyj transformers-0.5.6.2
    unix-2.7.2.2 vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
    vty-5.39-7gJNXoTzFFy85rvoBR06CX
    word-wrap-0.5-3FjAsEO4C5WFJn8awNgTg5

haddock-interfaces:   /usr/share/doc/haskell-brick0.71/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick0.71/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

