#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 atomic-write
version:              0.2.1.0
visibility:           public
id:                   atomic-write-0.2.1.0-LOQnifIkDlnBR6ddi82jGu
key:                  atomic-write-0.2.1.0-LOQnifIkDlnBR6ddi82jGu
license:              MIT
copyright:            2015-2019 Stack Builders Inc.
maintainer:           support@stackbuilders.com
author:               Justin Leitgeb
homepage:             https://github.com/stackbuilders/atomic-write
synopsis:             Atomically write to a file
description:

    Atomically write to a file on POSIX-compliant systems while preserving
    permissions.

    On most Unix systems, `mv` is an atomic operation. This makes it simple to write
    to a file atomically just by using the mv operation. However, this will
    destroy the permissions on the original file. This library does the following
    to preserve permissions while atomically writing to a file:

    * If an original file exists, take those permissions and apply them to the
    temp file before `mv`ing the file into place.

    * If the original file does not exist, create a following with default
    permissions (based on the currently-active umask).

    This way, when the file is `mv`'\''ed into place, the permissions will be the ones
    held by the original file.

    This library is based on similar implementations found in common libraries in
    Ruby and Python:

    * <http://apidock.com/rails/File/atomic_write/class Ruby on Rails includes a similar method called atomic_write>

    * <https://github.com/chef/chef/blob/c4631816132fcfefaba3d123a1d0dfe8bc2866bb/lib/chef/file_content_management/deploy/mv_unix.rb#L23:L71 Chef includes atomic update functionality>

    * <https://github.com/sashka/atomicfile There is a python library for atomically updating a file>

    To use `atomic-write`, import the module corresponding to the type you wish to
    write atomically, e.g., to write a (strict) ByteString atomically:

    > import System.AtomicWrite.Writer.ByteString

    Then you can use the atomicWriteFile function that accepts a `FilePath` and a
    `ByteString`, e.g.:

    > atomicWriteFile myFilePath myByteString

category:             System
abi:                  9712d012de15e43c1d243aa1325f3c84
exposed:              True
exposed-modules:
    System.AtomicWrite.Writer.ByteString
    System.AtomicWrite.Writer.ByteString.Binary
    System.AtomicWrite.Writer.ByteStringBuilder
    System.AtomicWrite.Writer.LazyByteString
    System.AtomicWrite.Writer.LazyByteString.Binary
    System.AtomicWrite.Writer.LazyText
    System.AtomicWrite.Writer.LazyText.Binary
    System.AtomicWrite.Writer.String
    System.AtomicWrite.Writer.String.Binary
    System.AtomicWrite.Writer.Text
    System.AtomicWrite.Writer.Text.Binary

hidden-modules:       System.AtomicWrite.Internal
import-dirs:          /usr/lib/ghc-9.2.8/site-local/atomic-write-0.2.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/atomic-write-0.2.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-atomic-write
hs-libraries:         HSatomic-write-0.2.1.0-LOQnifIkDlnBR6ddi82jGu
depends:
    base-4.16.4.0 bytestring-0.11.4.0 directory-1.3.6.2
    filepath-1.4.2.2 temporary-1.3-FDskYhMei4uKi1JCFLXz31 text-1.2.5.0
    unix-compat-0.7.2-9EkyOdRG6Oq7mRyWipBzHf

haddock-interfaces:
    /usr/share/doc/haskell-atomic-write/html/atomic-write.haddock

haddock-html:         /usr/share/doc/haskell-atomic-write/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

