#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
key:                  aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  1c2ac7a7c1c35a696c047b49cc535f4e
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.2.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
depends:
    OneTuple-0.4.1.1-CKI5QzdtVIT6hZ1Anx4wlf
    QuickCheck-2.14.3-5Q3LTiKAdB0LFKfPwDt7Ga
    attoparsec-0.14.4-DN7s9Fr9c113K5agmmE0LB base-4.16.4.0
    base-compat-batteries-0.12.2-5CHPed6R1NJ7UGbNvch4MS
    bytestring-0.11.4.0 containers-0.6.5.1
    data-fix-0.3.2-DRWkqlruoBu8G3jd6MGomI deepseq-1.4.6.1
    dlist-1.0-HCxoMn9TirQDgPCFxho7O exceptions-0.10.4
    generically-0.1.1-JMiBGdLJUYCDi0nkPCwFlG ghc-prim-0.8.0
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    indexed-traversable-0.1.4-6wPCwLr0dTz5YsFQcHKUoV
    primitive-0.7.4.0-I9XTAmFqErC1hXdXvvNzkS
    scientific-0.3.7.0-7nXcZobZD337Jkf1NR7gHa
    semialign-1.2.0.1-FwAdcScZlCCAOTpXC8sBnb
    strict-0.4.0.1-8lBzBTysaJf7j59NPrtuU7
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg template-haskell-2.18.0.0
    text-1.2.5.0 text-short-0.1.6-7dqeCbTHeH0F2s6oD6Dpcz
    th-abstraction-0.4.5.0-FQrzhXbdvQX3Z0wTw3euNu
    these-1.1.1.1-IjaKzDKQUlV4D72LRxTl4W time-1.11.1.1
    time-compat-1.9.6.1-4k0nw0k2EQ59NIrHgO4jEy
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    uuid-types-1.0.5.1-J2sbKAR6gu99vJPWCEy8Jh
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
    witherable-0.4.2-LiLZJf6qGi6LNxFzZj2P1c

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

