/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.LanguageSpecificProjectGenerator;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public abstract class LanguageLibraryProjectInitDescriptor
implements LanguageSpecificProjectGenerator {
    protected String withPackage(InitSettings settings, String className) {
        if (settings.getPackageName().isEmpty()) {
            return className;
        }
        return settings.getPackageName() + "." + className;
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return Collections.singleton(ModularizationOption.SINGLE_PROJECT);
    }

    @Override
    public Optional<String> getFurtherReading(InitSettings settings) {
        return Optional.empty();
    }

    protected BuildScriptBuilder.SuiteSpec configureDefaultTestSuite(BuildScriptBuilder buildScriptBuilder, BuildInitTestFramework testFramework, TemplateLibraryVersionProvider libraryVersionProvider) {
        return this.addTestSuite("test", buildScriptBuilder, testFramework, libraryVersionProvider);
    }

    protected BuildScriptBuilder.SuiteSpec addTestSuite(String name, BuildScriptBuilder buildScriptBuilder, BuildInitTestFramework testFramework, TemplateLibraryVersionProvider libraryVersionProvider) {
        switch (testFramework) {
            case JUNIT: {
                return buildScriptBuilder.testing().junitSuite(name, libraryVersionProvider);
            }
            case JUNIT_JUPITER: {
                return buildScriptBuilder.testing().junitJupiterSuite(name, libraryVersionProvider);
            }
            case SPOCK: {
                return buildScriptBuilder.testing().spockSuite(name, libraryVersionProvider);
            }
            case KOTLINTEST: {
                BuildScriptBuilder.SuiteSpec kotlinTestSuite = buildScriptBuilder.testing().kotlinTestSuite(name, libraryVersionProvider);
                kotlinTestSuite.implementation("Use newer version of JUnit Engine for Kotlin Test", "org.junit.jupiter:junit-jupiter-engine:" + libraryVersionProvider.getVersion("junit-jupiter"));
                return kotlinTestSuite;
            }
            case TESTNG: {
                return buildScriptBuilder.testing().testNG(name, libraryVersionProvider);
            }
            case SCALATEST: {
                BuildScriptBuilder.SuiteSpec suiteSpec = buildScriptBuilder.testing().junitSuite(name, libraryVersionProvider);
                String scalaVersion = libraryVersionProvider.getVersion("scala");
                String scalaTestVersion = libraryVersionProvider.getVersion("scalatest");
                String scalaTestPlusJunitVersion = libraryVersionProvider.getVersion("scalatestplus-junit");
                String scalaXmlVersion = libraryVersionProvider.getVersion("scala-xml");
                suiteSpec.implementation("Use Scalatest for testing our library", "org.scalatest:scalatest_" + scalaVersion + ":" + scalaTestVersion, "org.scalatestplus:junit-4-13_" + scalaVersion + ":" + scalaTestPlusJunitVersion);
                suiteSpec.runtimeOnly("Need scala-xml at test runtime", "org.scala-lang.modules:scala-xml_" + scalaVersion + ":" + scalaXmlVersion);
                return suiteSpec;
            }
        }
        throw new IllegalArgumentException(testFramework + " is not yet supported.");
    }
}

