/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans;

import java.util.Comparator;
import java.util.List;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.booleans.BooleanListIterator;

public interface BooleanList
extends BooleanCollection,
Comparable<List<? extends Boolean>>,
List<Boolean> {
    @Override
    public BooleanListIterator iterator();

    public BooleanListIterator listIterator();

    public BooleanListIterator listIterator(int var1);

    public BooleanList subList(int var1, int var2);

    default public void setElements(boolean[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index2, boolean[] a) {
        this.setElements(index2, a, 0, a.length);
    }

    default public void setElements(int index2, boolean[] a, int offset2, int length) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
        BooleanArrays.ensureOffsetLength(a, offset2, length);
        if (index2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        BooleanListIterator iter = this.listIterator(index2);
        int i = 0;
        while (i < length) {
            iter.nextBoolean();
            iter.set(a[offset2 + i++]);
        }
    }

    @Override
    public boolean add(boolean var1);

    @Override
    public void add(int var1, boolean var2);

    @Override
    @Deprecated
    default public void add(int index2, Boolean key) {
        this.add(index2, (boolean)key);
    }

    @Override
    public boolean set(int var1, boolean var2);

    public boolean getBoolean(int var1);

    public int indexOf(boolean var1);

    public int lastIndexOf(boolean var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return BooleanCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Boolean get(int index2) {
        return this.getBoolean(index2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Boolean)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Boolean)o);
    }

    @Override
    @Deprecated
    default public boolean add(Boolean k) {
        return this.add((boolean)k);
    }

    public boolean removeBoolean(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return BooleanCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Boolean remove(int index2) {
        return this.removeBoolean(index2);
    }

    @Override
    @Deprecated
    default public Boolean set(int index2, Boolean k) {
        return this.set(index2, (boolean)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Boolean> comparator) {
        this.sort(BooleanComparators.asBooleanComparator(comparator));
    }

    default public void sort(BooleanComparator comparator) {
        if (comparator == null) {
            this.unstableSort(comparator);
        } else {
            boolean[] elements = this.toBooleanArray();
            BooleanArrays.stableSort(elements, comparator);
            this.setElements(elements);
        }
    }

    default public void unstableSort(BooleanComparator comparator) {
        boolean[] elements = this.toBooleanArray();
        if (comparator == null) {
            BooleanArrays.unstableSort(elements);
        } else {
            BooleanArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

