/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.Pair;
import org.gradle.internal.Transformers;
import org.gradle.internal.deprecation.DeprecationLogger;

@Deprecated
public abstract class CollectionUtils {
    private static void logDeprecation() {
        DeprecationLogger.deprecateType(CollectionUtils.class).willBeRemovedInGradle9().withUpgradeGuideSection(7, "org_gradle_util_reports_deprecations").nagUser();
    }

    public CollectionUtils() {
        CollectionUtils.logDeprecation();
    }

    @Nullable
    public static <T> T findSingle(Iterable<T> source) {
        CollectionUtils.logDeprecation();
        return Iterables.isEmpty(source) ? null : (T)CollectionUtils.singleInternal(source);
    }

    public static <T> T single(Iterable<? extends T> source) {
        CollectionUtils.logDeprecation();
        return CollectionUtils.singleInternal(source);
    }

    private static <T> T singleInternal(Iterable<? extends T> source) {
        Iterator<T> iterator = source.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException("Expecting collection with single element, got none.");
        }
        T element = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("Expecting collection with single element, got multiple.");
        }
        return element;
    }

    public static <T> Collection<? extends T> checkedCast(Class<T> type, Collection<?> input) {
        CollectionUtils.logDeprecation();
        for (Object o : input) {
            Cast.castNullable(type, o);
        }
        return (Collection)Cast.uncheckedNonnullCast(input);
    }

    @Nullable
    public static <T> T findFirst(Iterable<? extends T> source, Spec<? super T> filter) {
        CollectionUtils.logDeprecation();
        for (T item : source) {
            if (!filter.isSatisfiedBy(item)) continue;
            return item;
        }
        return null;
    }

    @Nullable
    public static <T> T findFirst(T[] source, Spec<? super T> filter) {
        CollectionUtils.logDeprecation();
        for (T thing : source) {
            if (!filter.isSatisfiedBy(thing)) continue;
            return thing;
        }
        return null;
    }

    public static <T> T first(Iterable<? extends T> source) {
        CollectionUtils.logDeprecation();
        return source.iterator().next();
    }

    public static <T> boolean any(Iterable<? extends T> source, Spec<? super T> filter) {
        return CollectionUtils.findFirst(source, filter) != null;
    }

    public static <T> boolean any(T[] source, Spec<? super T> filter) {
        return CollectionUtils.findFirst(source, filter) != null;
    }

    public static <T> Set<T> filter(Set<? extends T> set, Spec<? super T> filter) {
        return CollectionUtils.filter(set, new LinkedHashSet(), filter);
    }

    public static <T> List<T> filter(List<? extends T> list, Spec<? super T> filter) {
        return CollectionUtils.filter(list, Lists.newArrayListWithCapacity((int)list.size()), filter);
    }

    public static <T> List<T> filter(T[] array, Spec<? super T> filter) {
        return CollectionUtils.filter(Arrays.asList(array), Lists.newArrayListWithCapacity((int)array.length), filter);
    }

    public static <T> List<T> sort(Iterable<? extends T> things, Comparator<? super T> comparator) {
        List<? extends T> copy = CollectionUtils.toMutableList(things);
        Collections.sort(copy, comparator);
        return copy;
    }

    public static <T extends Comparable<T>> List<T> sort(Iterable<T> things) {
        List<T> copy = CollectionUtils.toMutableList(things);
        Collections.sort(copy);
        return copy;
    }

    public static <T, C extends Collection<T>> C filter(Iterable<? extends T> source, C destination, Spec<? super T> filter) {
        CollectionUtils.logDeprecation();
        for (T item : source) {
            if (!filter.isSatisfiedBy(item)) continue;
            destination.add(item);
        }
        return destination;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Spec<Map.Entry<K, V>> filter) {
        return CollectionUtils.filter(map, new HashMap(), filter);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Map<K, V> destination, Spec<Map.Entry<K, V>> filter) {
        CollectionUtils.logDeprecation();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.isSatisfiedBy(entry)) continue;
            destination.put(entry.getKey(), entry.getValue());
        }
        return destination;
    }

    public static <R, I> R[] collectArray(I[] list, Class<R> newType, Transformer<? extends R, ? super I> transformer) {
        Object[] destination = (Object[])Array.newInstance(newType, list.length);
        return CollectionUtils.collectArray(list, destination, transformer);
    }

    public static <R, I> R[] collectArray(I[] list, R[] destination, Transformer<? extends R, ? super I> transformer) {
        CollectionUtils.logDeprecation();
        assert (list.length <= destination.length);
        for (int i = 0; i < list.length; ++i) {
            destination[i] = transformer.transform(list[i]);
        }
        return destination;
    }

    public static <R, I> List<R> collect(I[] list, Transformer<? extends R, ? super I> transformer) {
        return CollectionUtils.collect(Arrays.asList(list), transformer);
    }

    public static <R, I> Set<R> collect(Set<? extends I> set, Transformer<? extends R, ? super I> transformer) {
        return CollectionUtils.collect(set, new HashSet(set.size()), transformer);
    }

    public static <R, I> List<R> collect(Iterable<? extends I> source, Transformer<? extends R, ? super I> transformer) {
        if (source instanceof Collection) {
            Collection collection = (Collection)Cast.uncheckedNonnullCast(source);
            return CollectionUtils.collect(source, new ArrayList(collection.size()), transformer);
        }
        return CollectionUtils.collect(source, new LinkedList(), transformer);
    }

    public static <R, I, C extends Collection<R>> C collect(Iterable<? extends I> source, C destination, Transformer<? extends R, ? super I> transformer) {
        CollectionUtils.logDeprecation();
        return CollectionUtils.collectInternal(source, destination, transformer);
    }

    private static <R, I, C extends Collection<R>> C collectInternal(Iterable<? extends I> source, C destination, Transformer<? extends R, ? super I> transformer) {
        for (I item : source) {
            destination.add((Object)transformer.transform(item));
        }
        return destination;
    }

    public static List<String> toStringList(Iterable<?> iterable) {
        return CollectionUtils.collect(iterable, new LinkedList(), Transformers.asString());
    }

    public static List<?> flattenCollections(Object ... things) {
        return CollectionUtils.flattenCollections(Object.class, things);
    }

    public static <T> List<T> flattenCollections(Class<T> type, Object ... things) {
        CollectionUtils.logDeprecation();
        return CollectionUtils.flattenCollectionsInternal(type, things);
    }

    private static <T> List<T> flattenCollectionsInternal(Class<T> type, Object ... things) {
        if (things == null) {
            return Collections.singletonList(null);
        }
        if (things.length == 0) {
            return Collections.emptyList();
        }
        if (things.length == 1) {
            Object thing = things[0];
            if (thing == null) {
                return Collections.singletonList(null);
            }
            if (thing.getClass().isArray()) {
                Object[] thingArray = (Object[])thing;
                ArrayList<T> list = new ArrayList<T>(thingArray.length);
                for (Object thingThing : thingArray) {
                    list.addAll(CollectionUtils.flattenCollections(type, thingThing));
                }
                return list;
            }
            if (thing instanceof Collection) {
                Collection collection = (Collection)thing;
                ArrayList<T> list = new ArrayList<T>();
                for (Object element : collection) {
                    list.addAll(CollectionUtils.flattenCollections(type, element));
                }
                return list;
            }
            return Collections.singletonList(Cast.cast(type, (Object)thing));
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Object thing : things) {
            list.addAll(CollectionUtils.flattenCollections(type, thing));
        }
        return list;
    }

    public static <T> List<T> toList(Iterable<? extends T> things) {
        if (things instanceof List) {
            CollectionUtils.logDeprecation();
            List castThings = (List)things;
            return castThings;
        }
        return CollectionUtils.toMutableList(things);
    }

    public static <T> List<T> toList(Enumeration<? extends T> things) {
        CollectionUtils.logDeprecation();
        ArrayList<T> list = new ArrayList<T>();
        while (things.hasMoreElements()) {
            ((AbstractList)list).add(things.nextElement());
        }
        return list;
    }

    private static <T> List<T> toMutableList(Iterable<? extends T> things) {
        CollectionUtils.logDeprecation();
        if (things == null) {
            return new ArrayList(0);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T thing : things) {
            list.add(thing);
        }
        return list;
    }

    public static <T> List<T> intersection(Collection<? extends Collection<T>> availableValuesByDescriptor) {
        CollectionUtils.logDeprecation();
        ArrayList<T> result = new ArrayList<T>();
        Iterator<Collection<T>> iterator = availableValuesByDescriptor.iterator();
        if (iterator.hasNext()) {
            Collection<T> firstSet = iterator.next();
            result.addAll(firstSet);
            while (iterator.hasNext()) {
                Collection<T> next = iterator.next();
                result.retainAll(next);
            }
        }
        return result;
    }

    public static <T> List<T> toList(T[] things) {
        CollectionUtils.logDeprecation();
        if (things == null || things.length == 0) {
            return new ArrayList(0);
        }
        ArrayList list = new ArrayList(things.length);
        Collections.addAll(list, things);
        return list;
    }

    public static <T> Set<T> toSet(Iterable<? extends T> things) {
        CollectionUtils.logDeprecation();
        if (things == null) {
            return new HashSet(0);
        }
        if (things instanceof Set) {
            Set castThings = (Set)things;
            return castThings;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T thing : things) {
            set.add(thing);
        }
        return set;
    }

    public static <E> List<E> compact(List<E> list) {
        CollectionUtils.logDeprecation();
        boolean foundAtLeastOneNull = false;
        List<E> compacted = null;
        int i = 0;
        for (E element : list) {
            if (element == null) {
                if (!foundAtLeastOneNull) {
                    compacted = new ArrayList(list.size());
                    if (i > 0) {
                        compacted.addAll(list.subList(0, i));
                    }
                }
                foundAtLeastOneNull = true;
            } else if (foundAtLeastOneNull) {
                compacted.add(element);
            }
            ++i;
        }
        return foundAtLeastOneNull ? compacted : list;
    }

    public static <C extends Collection<String>> C stringize(Iterable<?> source, C destination) {
        CollectionUtils.logDeprecation();
        return CollectionUtils.stringizeInternal(source, destination);
    }

    public static List<String> stringize(Collection<?> source) {
        return CollectionUtils.stringizeInternal(source, new ArrayList(source.size()));
    }

    private static <C extends Collection<String>> C stringizeInternal(Iterable<?> source, C destination) {
        return CollectionUtils.collectInternal(source, destination, Transformers.asString());
    }

    public static <E> boolean replace(List<E> list, Spec<? super E> filter, Transformer<? extends E, ? super E> transformer) {
        CollectionUtils.logDeprecation();
        boolean replaced = false;
        int i = 0;
        for (Object object : list) {
            if (filter.isSatisfiedBy(object)) {
                list.set(i, transformer.transform(object));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }

    public static <K, V> void collectMap(Map<K, V> destination, Iterable<? extends V> items, Transformer<? extends K, ? super V> keyGenerator) {
        CollectionUtils.logDeprecation();
        for (V item : items) {
            destination.put(keyGenerator.transform(item), item);
        }
    }

    public static <K, V> Map<K, V> collectMap(Iterable<? extends V> items, Transformer<? extends K, ? super V> keyGenerator) {
        LinkedHashMap map = new LinkedHashMap();
        CollectionUtils.collectMap(map, items, keyGenerator);
        return map;
    }

    public static <K, V> void collectMapValues(Map<K, V> destination, Iterable<? extends K> keys, Transformer<? extends V, ? super K> keyGenerator) {
        CollectionUtils.logDeprecation();
        for (K item : keys) {
            destination.put(item, keyGenerator.transform(item));
        }
    }

    public static <K, V> Map<K, V> collectMapValues(Iterable<? extends K> keys, Transformer<? extends V, ? super K> keyGenerator) {
        LinkedHashMap map = new LinkedHashMap();
        CollectionUtils.collectMapValues(map, keys, keyGenerator);
        return map;
    }

    public static <T> boolean every(Iterable<? extends T> things, Spec<? super T> predicate) {
        CollectionUtils.logDeprecation();
        for (T thing : things) {
            if (predicate.isSatisfiedBy(thing)) continue;
            return false;
        }
        return true;
    }

    public static <T, C extends Collection<? super T>> C addAll(C t1, Iterable<? extends T> t2) {
        CollectionUtils.logDeprecation();
        for (T t : t2) {
            t1.add(t);
        }
        return t1;
    }

    public static <T, C extends Collection<? super T>> C addAll(C t1, T ... t2) {
        CollectionUtils.logDeprecation();
        Collections.addAll(t1, t2);
        return t1;
    }

    public static <T> SetDiff<T> diffSetsBy(Set<? extends T> left, Set<? extends T> right, Transformer<?, T> compareBy) {
        CollectionUtils.logDeprecation();
        if (left == null) {
            throw new NullPointerException("'left' set is null");
        }
        if (right == null) {
            throw new NullPointerException("'right' set is null");
        }
        SetDiff setDiff = new SetDiff(false);
        Map<?, T> indexedLeft = CollectionUtils.collectMap(left, compareBy);
        Map<?, T> indexedRight = CollectionUtils.collectMap(right, compareBy);
        for (Map.Entry<?, T> leftEntry : indexedLeft.entrySet()) {
            T rightValue = indexedRight.remove(leftEntry.getKey());
            if (rightValue == null) {
                setDiff.leftOnly.add(leftEntry.getValue());
                continue;
            }
            Pair pair = Pair.of(leftEntry.getValue(), rightValue);
            setDiff.common.add(pair);
        }
        for (Map.Entry<?, ? extends T> rightValue : indexedRight.values()) {
            setDiff.rightOnly.add(rightValue);
        }
        return setDiff;
    }

    public static String join(String separator, Object[] objects) {
        return CollectionUtils.join(separator, objects == null ? null : Arrays.asList(objects));
    }

    public static String join(String separator, Iterable<?> objects) {
        CollectionUtils.logDeprecation();
        if (separator == null) {
            throw new NullPointerException("The 'separator' cannot be null");
        }
        if (objects == null) {
            throw new NullPointerException("The 'objects' cannot be null");
        }
        StringBuilder string = new StringBuilder();
        Iterator<?> iterator = objects.iterator();
        if (iterator.hasNext()) {
            string.append(iterator.next().toString());
            while (iterator.hasNext()) {
                string.append(separator);
                string.append(iterator.next().toString());
            }
        }
        return string.toString();
    }

    public static <T> Pair<Collection<T>, Collection<T>> partition(Iterable<T> items, Spec<? super T> predicate) {
        CollectionUtils.logDeprecation();
        Preconditions.checkNotNull(items, (Object)"Cannot partition null Collection");
        Preconditions.checkNotNull(predicate, (Object)"Cannot apply null Spec when partitioning");
        LinkedList<T> left = new LinkedList<T>();
        LinkedList<T> right = new LinkedList<T>();
        for (T item : items) {
            if (predicate.isSatisfiedBy(item)) {
                left.add(item);
                continue;
            }
            right.add(item);
        }
        return Pair.of(left, right);
    }

    public static <T, I> T inject(T target, Iterable<? extends I> items, Action<InjectionStep<T, I>> action) {
        CollectionUtils.logDeprecation();
        if (target == null) {
            throw new NullPointerException("The 'target' cannot be null");
        }
        if (items == null) {
            throw new NullPointerException("The 'items' cannot be null");
        }
        if (action == null) {
            throw new NullPointerException("The 'action' cannot be null");
        }
        for (I item : items) {
            action.execute(new InjectionStep(target, item, false));
        }
        return target;
    }

    public static <K, V> Map<K, Collection<V>> groupBy(Iterable<? extends V> iterable, Transformer<? extends K, V> grouper) {
        CollectionUtils.logDeprecation();
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (V element : iterable) {
            Object key = grouper.transform(element);
            builder.put(key, element);
        }
        return builder.build().asMap();
    }

    public static <T> Iterable<? extends T> unpack(final Iterable<? extends Factory<? extends T>> factories) {
        CollectionUtils.logDeprecation();
        return new Iterable<T>(){
            private final Iterator<? extends Factory<? extends T>> delegate;
            {
                this.delegate = factories.iterator();
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return delegate.hasNext();
                    }

                    @Override
                    public T next() {
                        return ((Factory)delegate.next()).create();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Nullable
    public static <T> List<T> nonEmptyOrNull(Iterable<T> iterable) {
        CollectionUtils.logDeprecation();
        ImmutableList list = ImmutableList.copyOf(iterable);
        return list.isEmpty() ? null : list;
    }

    public static String asCommandLine(Iterable<String> arguments) {
        CollectionUtils.logDeprecation();
        return Joiner.on((String)" ").join(CollectionUtils.collect(arguments, Transformers.asSafeCommandLineArgument()));
    }

    @Deprecated
    public static class InjectionStep<T, I> {
        private final T target;
        private final I item;

        public InjectionStep(T target, I item) {
            this(target, item, true);
        }

        private InjectionStep(T target, I item, boolean logDeprecation) {
            this.target = target;
            this.item = item;
            if (logDeprecation) {
                CollectionUtils.logDeprecation();
            }
        }

        public T getTarget() {
            return this.target;
        }

        public I getItem() {
            return this.item;
        }
    }

    public static class SetDiff<T> {
        public Set<T> leftOnly = new HashSet<T>();
        public Set<Pair<T, T>> common = new HashSet<Pair<T, T>>();
        public Set<T> rightOnly = new HashSet<T>();

        public SetDiff() {
            this(true);
        }

        private SetDiff(boolean logDeprecation) {
            if (logDeprecation) {
                CollectionUtils.logDeprecation();
            }
        }
    }
}

