/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import com.google.common.collect.Maps;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.profile.CompositeOperation;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.FragmentedOperation;
import org.gradle.profile.Operation;
import org.gradle.profile.ProjectProfile;
import org.gradle.util.internal.CollectionUtils;

@ServiceScope(value=Scopes.BuildTree.class)
public class BuildProfile {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd - HH:mm:ss");
    private final Map<String, ProjectProfile> projects = new LinkedHashMap<String, ProjectProfile>();
    private final Map<String, ContinuousOperation> dependencySets = new LinkedHashMap<String, ContinuousOperation>();
    private final Map<String, FragmentedOperation> transformations = Maps.newLinkedHashMap();
    private long profilingStarted;
    private long buildStarted;
    private long settingsEvaluated;
    private long projectsLoaded;
    private long projectsEvaluated;
    private long buildFinished;
    private final StartParameter startParameter;
    private boolean successful;
    private File buildDir;

    public BuildProfile(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    public long getBuildStarted() {
        return this.buildStarted;
    }

    public String getBuildDescription() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.startParameter.getExcludedTaskNames()) {
            sb.append("-x ");
            sb.append(name);
            sb.append(" ");
        }
        for (String name : this.startParameter.getTaskNames()) {
            sb.append(name);
            sb.append(" ");
        }
        String tasks = sb.toString();
        if (tasks.length() == 0) {
            tasks = "(no tasks specified)";
        }
        return "Profiled build: " + tasks;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public ProjectProfile getProjectProfile(String projectPath) {
        ProjectProfile result = this.projects.get(projectPath);
        if (result == null) {
            result = new ProjectProfile(projectPath);
            this.projects.put(projectPath, result);
        }
        return result;
    }

    public List<ProjectProfile> getProjects() {
        return CollectionUtils.sort(this.projects.values(), Operation.slowestFirst());
    }

    public CompositeOperation<Operation> getProjectConfiguration() {
        List<ContinuousOperation> operations = new ArrayList();
        for (ProjectProfile projectProfile : this.projects.values()) {
            operations.add(projectProfile.getConfigurationOperation());
        }
        operations = CollectionUtils.sort(operations, Operation.slowestFirst());
        return new CompositeOperation<Operation>(operations);
    }

    public ContinuousOperation getDependencySetProfile(String dependencySetDescription) {
        ContinuousOperation profile = this.dependencySets.get(dependencySetDescription);
        if (profile == null) {
            profile = new ContinuousOperation(dependencySetDescription);
            this.dependencySets.put(dependencySetDescription, profile);
        }
        return profile;
    }

    public CompositeOperation<ContinuousOperation> getDependencySets() {
        List profiles = CollectionUtils.sort(this.dependencySets.values(), Operation.slowestFirst());
        return new CompositeOperation<ContinuousOperation>(profiles);
    }

    public FragmentedOperation getTransformationProfile(String transformationDescription) {
        FragmentedOperation profile = this.transformations.get(transformationDescription);
        if (profile == null) {
            profile = new FragmentedOperation(transformationDescription);
            this.transformations.put(transformationDescription, profile);
        }
        return profile;
    }

    public CompositeOperation<FragmentedOperation> getTransformations() {
        List profiles = CollectionUtils.sort(this.transformations.values(), Operation.slowestFirst());
        return new CompositeOperation<FragmentedOperation>(profiles);
    }

    public void setProfilingStarted(long profilingStarted) {
        this.profilingStarted = profilingStarted;
    }

    public void setBuildStarted(long buildStarted) {
        this.buildStarted = buildStarted;
    }

    public void setSettingsEvaluated(long settingsEvaluated) {
        this.settingsEvaluated = settingsEvaluated;
    }

    public void setProjectsLoaded(long projectsLoaded) {
        this.projectsLoaded = projectsLoaded;
    }

    public void setProjectsEvaluated(long projectsEvaluated) {
        this.projectsEvaluated = projectsEvaluated;
    }

    public void setBuildFinished(long buildFinished) {
        this.buildFinished = buildFinished;
    }

    public long getElapsedStartup() {
        return this.buildStarted - this.profilingStarted;
    }

    public long getElapsedTotal() {
        return this.buildFinished - this.profilingStarted;
    }

    public long getElapsedSettings() {
        return this.settingsEvaluated - this.buildStarted;
    }

    public long getElapsedProjectsLoading() {
        return this.projectsLoaded - this.settingsEvaluated;
    }

    public long getElapsedProjectsConfiguration() {
        return this.projectsEvaluated - this.projectsLoaded;
    }

    public long getElapsedArtifactTransformTime() {
        long result = 0L;
        for (FragmentedOperation transform : this.transformations.values()) {
            result += transform.getElapsedTime();
        }
        return result;
    }

    public long getElapsedTotalExecutionTime() {
        long result = 0L;
        for (ProjectProfile projectProfile : this.projects.values()) {
            result += projectProfile.getElapsedTime();
        }
        return result;
    }

    public String getBuildStartedDescription() {
        return "Started on: " + DATE_FORMAT.format(this.buildStarted);
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }
}

