/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepositoryMetaDataProvider;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextualMetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradleModuleMetadataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyXmlModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.repositories.AbstractAuthenticationSupportedRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultUrlArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.IvyRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.layout.AbstractRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.DefaultIvyPatternRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.GradleRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.IvyRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.MavenRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.ResolvedPattern;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultArtifactMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultGradleModuleMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultIvyDescriptorMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.RedirectingGradleMetadataModuleMetadataSource;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.PatternBasedResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ivy.MutableIvyModuleResolveMetadata;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.caching.ImplicitInputsCapturingInstantiator;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

public class DefaultIvyArtifactRepository
extends AbstractAuthenticationSupportedRepository
implements IvyArtifactRepository,
ResolutionAwareRepository,
PublicationAwareRepository {
    private Set<String> schemes = null;
    private AbstractRepositoryLayout layout;
    private final DefaultUrlArtifactRepository urlArtifactRepository;
    private final AdditionalPatternsRepositoryLayout additionalPatternsLayout;
    private final FileResolver fileResolver;
    private final RepositoryTransportFactory transportFactory;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final MetaDataProvider metaDataProvider;
    private final Instantiator instantiator;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final FileStore<String> externalResourcesFileStore;
    private final IvyContextManager ivyContextManager;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final InstantiatorFactory instantiatorFactory;
    private final FileResourceRepository fileResourceRepository;
    private final GradleModuleMetadataParser moduleMetadataParser;
    private final IvyMutableModuleMetadataFactory metadataFactory;
    private final IsolatableFactory isolatableFactory;
    private final ChecksumService checksumService;
    private final IvyMetadataSources metadataSources = new IvyMetadataSources();

    public DefaultIvyArtifactRepository(FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, FileStore<String> externalResourcesFileStore, AuthenticationContainer authenticationContainer, IvyContextManager ivyContextManager, ImmutableModuleIdentifierFactory moduleIdentifierFactory, InstantiatorFactory instantiatorFactory, FileResourceRepository fileResourceRepository, GradleModuleMetadataParser moduleMetadataParser, IvyMutableModuleMetadataFactory metadataFactory, IsolatableFactory isolatableFactory, ObjectFactory objectFactory, DefaultUrlArtifactRepository.Factory urlArtifactRepositoryFactory, ChecksumService checksumService, ProviderFactory providerFactory, VersionParser versionParser) {
        super((Instantiator)instantiatorFactory.decorateLenient(), authenticationContainer, objectFactory, providerFactory, versionParser);
        this.fileResolver = fileResolver;
        this.urlArtifactRepository = urlArtifactRepositoryFactory.create("Ivy", this::getDisplayName);
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.externalResourcesFileStore = externalResourcesFileStore;
        this.additionalPatternsLayout = new AdditionalPatternsRepositoryLayout(fileResolver);
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.instantiatorFactory = instantiatorFactory;
        this.fileResourceRepository = fileResourceRepository;
        this.moduleMetadataParser = moduleMetadataParser;
        this.metadataFactory = metadataFactory;
        this.isolatableFactory = isolatableFactory;
        this.checksumService = checksumService;
        this.layout = new GradleRepositoryLayout();
        this.metaDataProvider = new MetaDataProvider();
        this.instantiator = instantiatorFactory.decorateLenient();
        this.ivyContextManager = ivyContextManager;
        this.metadataSources.setDefaults();
    }

    @Override
    public String getDisplayName() {
        URI url = this.getUrl();
        if (url == null) {
            return super.getDisplayName();
        }
        return super.getDisplayName() + '(' + url + ')';
    }

    @Override
    public IvyResolver createPublisher() {
        return this.createRealResolver();
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.createRealResolver();
    }

    @Override
    protected RepositoryDescriptor createDescriptor() {
        boolean m2Compatible;
        String layoutType;
        Set<String> schemes = this.getSchemes();
        this.validate(schemes);
        if (this.layout instanceof GradleRepositoryLayout) {
            layoutType = "Gradle";
            m2Compatible = false;
        } else if (this.layout instanceof MavenRepositoryLayout) {
            layoutType = "Maven";
            m2Compatible = true;
        } else if (this.layout instanceof IvyRepositoryLayout) {
            layoutType = "Ivy";
            m2Compatible = false;
        } else if (this.layout instanceof DefaultIvyPatternRepositoryLayout) {
            layoutType = "Pattern";
            m2Compatible = ((DefaultIvyPatternRepositoryLayout)this.layout).getM2Compatible();
        } else {
            layoutType = "Unknown";
            m2Compatible = false;
        }
        return ((IvyRepositoryDescriptor.Builder)((IvyRepositoryDescriptor.Builder)((IvyRepositoryDescriptor.Builder)new IvyRepositoryDescriptor.Builder(this.getName(), this.urlArtifactRepository.getUrl()).setAuthenticated(this.usesCredentials())).setAuthenticationSchemes((List)this.getAuthenticationSchemes())).setMetadataSources((List)this.metadataSources.asList())).setLayoutType(layoutType).setM2Compatible(m2Compatible).setIvyPatterns((Collection<String>)Sets.union(this.layout.getIvyPatterns(), (Set)this.additionalPatternsLayout.ivyPatterns)).setArtifactPatterns((Collection<String>)Sets.union(this.layout.getArtifactPatterns(), (Set)this.additionalPatternsLayout.artifactPatterns)).create();
    }

    private IvyResolver createRealResolver() {
        Set<String> schemes = this.getSchemes();
        this.validate(schemes);
        IvyResolver resolver = this.createResolver(schemes);
        URI uri = this.urlArtifactRepository.getUrl();
        this.layout.apply(uri, resolver);
        this.additionalPatternsLayout.apply(uri, resolver);
        return resolver;
    }

    private IvyResolver createResolver(Set<String> schemes) {
        return this.createResolver(this.transportFactory.createTransport(schemes, this.getName(), this.getConfiguredAuthentication(), this.urlArtifactRepository.createRedirectVerifier()));
    }

    private void validate(Set<String> schemes) {
        if (schemes.isEmpty()) {
            throw new InvalidUserDataException("You must specify a base url or at least one artifact pattern for the Ivy repository '" + this.getDisplayName() + "'.");
        }
    }

    private Set<String> getSchemes() {
        if (this.schemes == null) {
            URI uri = this.getUrl();
            this.schemes = new LinkedHashSet<String>();
            this.layout.addSchemes(uri, this.schemes);
            this.additionalPatternsLayout.addSchemes(uri, this.schemes);
        }
        return this.schemes;
    }

    private IvyResolver createResolver(RepositoryTransport transport) {
        ImplicitInputsCapturingInstantiator injector = this.createInjectorForMetadataSuppliers(transport, this.instantiatorFactory, this.getUrl(), this.externalResourcesFileStore);
        InstantiatingAction<ComponentMetadataSupplierDetails> supplierFactory = this.createComponentMetadataSupplierFactory(injector, this.isolatableFactory);
        InstantiatingAction<ComponentMetadataListerDetails> listerFactory = this.createComponentMetadataVersionLister(injector, this.isolatableFactory);
        return new IvyResolver(this.getName(), transport, this.locallyAvailableResourceFinder, this.metaDataProvider.dynamicResolve, this.artifactFileStore, supplierFactory, listerFactory, this.createMetadataSources(), IvyMetadataArtifactProvider.INSTANCE, injector, this.checksumService);
    }

    public void metadataSources(Action<? super IvyArtifactRepository.MetadataSources> configureAction) {
        this.invalidateDescriptor();
        this.metadataSources.reset();
        configureAction.execute((Object)this.metadataSources);
    }

    public IvyArtifactRepository.MetadataSources getMetadataSources() {
        return this.metadataSources;
    }

    private ImmutableMetadataSources createMetadataSources() {
        ImmutableList.Builder sources = ImmutableList.builder();
        DefaultGradleModuleMetadataSource gradleModuleMetadataSource = new DefaultGradleModuleMetadataSource(this.moduleMetadataParser, this.metadataFactory, true, this.checksumService);
        if (this.metadataSources.gradleMetadata) {
            sources.add((Object)gradleModuleMetadataSource);
        }
        if (this.metadataSources.ivyDescriptor) {
            DefaultIvyDescriptorMetadataSource ivyDescriptorMetadataSource = new DefaultIvyDescriptorMetadataSource(IvyMetadataArtifactProvider.INSTANCE, this.createIvyDescriptorParser(), this.fileResourceRepository, this.checksumService);
            if (this.metadataSources.ignoreGradleMetadataRedirection) {
                sources.add((Object)ivyDescriptorMetadataSource);
            } else {
                sources.add((Object)new RedirectingGradleMetadataModuleMetadataSource(ivyDescriptorMetadataSource, gradleModuleMetadataSource));
            }
        }
        if (this.metadataSources.artifact) {
            sources.add((Object)new DefaultArtifactMetadataSource(this.metadataFactory));
        }
        return new DefaultImmutableMetadataSources((Iterable<MetadataSource<?>>)sources.build());
    }

    private MetaDataParser<MutableIvyModuleResolveMetadata> createIvyDescriptorParser() {
        return new IvyContextualMetaDataParser<MutableIvyModuleResolveMetadata>(this.ivyContextManager, new IvyXmlModuleDescriptorParser(new IvyModuleDescriptorConverter(this.moduleIdentifierFactory), this.moduleIdentifierFactory, this.fileResourceRepository, this.metadataFactory));
    }

    public URI getUrl() {
        return this.urlArtifactRepository.getUrl();
    }

    @Override
    protected Collection<URI> getRepositoryUrls() {
        URI baseUri;
        ImmutableList.Builder builder = ImmutableList.builder();
        URI root = this.getUrl();
        if (root != null) {
            builder.add((Object)root);
        }
        for (String pattern : this.additionalPatternsLayout.artifactPatterns) {
            baseUri = new ResolvedPattern((String)pattern, (FileResolver)this.fileResolver).baseUri;
            if (baseUri == null) continue;
            builder.add((Object)baseUri);
        }
        for (String pattern : this.additionalPatternsLayout.ivyPatterns) {
            baseUri = new ResolvedPattern((String)pattern, (FileResolver)this.fileResolver).baseUri;
            if (baseUri == null) continue;
            builder.add((Object)baseUri);
        }
        return builder.build();
    }

    public void setUrl(URI url) {
        this.invalidateDescriptor();
        this.urlArtifactRepository.setUrl(url);
    }

    public void setUrl(Object url) {
        this.invalidateDescriptor();
        this.urlArtifactRepository.setUrl(url);
    }

    public void setAllowInsecureProtocol(boolean allowInsecureProtocol) {
        this.invalidateDescriptor();
        this.urlArtifactRepository.setAllowInsecureProtocol(allowInsecureProtocol);
    }

    public boolean isAllowInsecureProtocol() {
        return this.urlArtifactRepository.isAllowInsecureProtocol();
    }

    public void artifactPattern(String pattern) {
        this.invalidateDescriptor();
        this.additionalPatternsLayout.artifactPatterns.add(pattern);
    }

    public void ivyPattern(String pattern) {
        this.invalidateDescriptor();
        this.additionalPatternsLayout.ivyPatterns.add(pattern);
    }

    public void layout(String layoutName) {
        this.invalidateDescriptor();
        switch (layoutName) {
            case "ivy": {
                this.layout = (AbstractRepositoryLayout)this.instantiator.newInstance(IvyRepositoryLayout.class, new Object[0]);
                break;
            }
            case "maven": {
                this.layout = (AbstractRepositoryLayout)this.instantiator.newInstance(MavenRepositoryLayout.class, new Object[0]);
                break;
            }
            case "pattern": {
                this.layout = (AbstractRepositoryLayout)this.instantiator.newInstance(DefaultIvyPatternRepositoryLayout.class, new Object[0]);
                break;
            }
            default: {
                this.layout = (AbstractRepositoryLayout)this.instantiator.newInstance(GradleRepositoryLayout.class, new Object[0]);
            }
        }
    }

    public void patternLayout(Action<? super IvyPatternRepositoryLayout> config) {
        DefaultIvyPatternRepositoryLayout layout = (DefaultIvyPatternRepositoryLayout)this.instantiator.newInstance(DefaultIvyPatternRepositoryLayout.class, new Object[0]);
        this.layout = layout;
        config.execute((Object)layout);
    }

    public IvyArtifactRepositoryMetaDataProvider getResolve() {
        return this.metaDataProvider;
    }

    private static class IvyMetadataSources
    implements IvyArtifactRepository.MetadataSources {
        boolean gradleMetadata;
        boolean ivyDescriptor;
        boolean artifact;
        boolean ignoreGradleMetadataRedirection;

        private IvyMetadataSources() {
        }

        void setDefaults() {
            this.ivyDescriptor();
            this.ignoreGradleMetadataRedirection = false;
        }

        void reset() {
            this.gradleMetadata = false;
            this.ivyDescriptor = false;
            this.artifact = false;
            this.ignoreGradleMetadataRedirection = false;
        }

        List<String> asList() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.gradleMetadata) {
                list.add("gradleMetadata");
            }
            if (this.ivyDescriptor) {
                list.add("ivyDescriptor");
            }
            if (this.artifact) {
                list.add("artifact");
            }
            if (this.ignoreGradleMetadataRedirection) {
                list.add("ignoreGradleMetadataRedirection");
            }
            return list;
        }

        public void gradleMetadata() {
            this.gradleMetadata = true;
        }

        public void ivyDescriptor() {
            this.ivyDescriptor = true;
        }

        public void artifact() {
            this.artifact = true;
        }

        public void ignoreGradleMetadataRedirection() {
            this.ignoreGradleMetadataRedirection = true;
        }

        public boolean isGradleMetadataEnabled() {
            return this.gradleMetadata;
        }

        public boolean isIvyDescriptorEnabled() {
            return this.ivyDescriptor;
        }

        public boolean isArtifactEnabled() {
            return this.artifact;
        }

        public boolean isIgnoreGradleMetadataRedirectionEnabled() {
            return this.ignoreGradleMetadataRedirection;
        }
    }

    private static class MetaDataProvider
    implements IvyArtifactRepositoryMetaDataProvider {
        boolean dynamicResolve;

        private MetaDataProvider() {
        }

        public boolean isDynamicMode() {
            return this.dynamicResolve;
        }

        public void setDynamicMode(boolean mode) {
            this.dynamicResolve = mode;
        }
    }

    private static class AdditionalPatternsRepositoryLayout
    extends AbstractRepositoryLayout {
        private final FileResolver fileResolver;
        private final Set<String> artifactPatterns = new LinkedHashSet<String>();
        private final Set<String> ivyPatterns = new LinkedHashSet<String>();

        public AdditionalPatternsRepositoryLayout(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        @Override
        public void apply(URI baseUri, PatternBasedResolver resolver) {
            for (String artifactPattern : this.artifactPatterns) {
                ResolvedPattern resolvedPattern = new ResolvedPattern(artifactPattern, this.fileResolver);
                resolver.addArtifactLocation(resolvedPattern.baseUri, resolvedPattern.pattern);
            }
            Set<String> usedIvyPatterns = this.ivyPatterns.isEmpty() ? this.artifactPatterns : this.ivyPatterns;
            for (String ivyPattern : usedIvyPatterns) {
                ResolvedPattern resolvedPattern = new ResolvedPattern(ivyPattern, this.fileResolver);
                resolver.addDescriptorLocation(resolvedPattern.baseUri, resolvedPattern.pattern);
            }
        }

        @Override
        public void addSchemes(URI baseUri, Set<String> schemes) {
            for (String pattern : this.artifactPatterns) {
                schemes.add(new ResolvedPattern((String)pattern, (FileResolver)this.fileResolver).scheme);
            }
            for (String pattern : this.ivyPatterns) {
                schemes.add(new ResolvedPattern((String)pattern, (FileResolver)this.fileResolver).scheme);
            }
        }

        @Override
        public Set<String> getIvyPatterns() {
            return ImmutableSet.copyOf(this.ivyPatterns);
        }

        @Override
        public Set<String> getArtifactPatterns() {
            return ImmutableSet.copyOf(this.artifactPatterns);
        }
    }
}

