/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyAdder;
import org.gradle.api.attributes.Category;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.JvmComponentDependencies;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ProjectTestFixtures;
import org.gradle.internal.deprecation.DeprecationLogger;

public abstract class DefaultJvmComponentDependencies
implements JvmComponentDependencies {
    private final DependencyAdder implementation;
    private final DependencyAdder compileOnly;
    private final DependencyAdder runtimeOnly;
    private final DependencyAdder annotationProcessor;

    @Inject
    public DefaultJvmComponentDependencies(DependencyAdder implementation, DependencyAdder compileOnly, DependencyAdder runtimeOnly, DependencyAdder annotationProcessor) {
        this.implementation = implementation;
        this.compileOnly = compileOnly;
        this.runtimeOnly = runtimeOnly;
        this.annotationProcessor = annotationProcessor;
    }

    @Override
    public DependencyAdder getImplementation() {
        return this.implementation;
    }

    @Override
    public DependencyAdder getCompileOnly() {
        return this.compileOnly;
    }

    @Override
    public DependencyAdder getRuntimeOnly() {
        return this.runtimeOnly;
    }

    @Override
    public DependencyAdder getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    @Inject
    protected abstract Project getCurrentProject();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    public ProjectDependency project(String projectPath) {
        return this.getDependencyFactory().create(this.getCurrentProject().project(projectPath));
    }

    public ProjectDependency project() {
        return this.getDependencyFactory().create(this.getCurrentProject());
    }

    public <D extends ModuleDependency> D platform(D dependency) {
        dependency.endorseStrictVersions();
        dependency.attributes(attributeContainer -> attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.getObjectFactory().named(Category.class, "platform"))));
        return dependency;
    }

    public <D extends ModuleDependency> D enforcedPlatform(D dependency) {
        if (dependency instanceof ExternalDependency) {
            DeprecationLogger.whileDisabled(() -> ((ExternalDependency)dependency).setForce(true));
        }
        dependency.attributes(attributeContainer -> attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.getObjectFactory().named(Category.class, "enforced-platform"))));
        return dependency;
    }

    public <D extends ModuleDependency> D testFixtures(D dependency) {
        if (dependency instanceof ExternalDependency) {
            dependency.capabilities(capabilities -> capabilities.requireCapability((Object)new ImmutableCapability(dependency.getGroup(), dependency.getName() + "-test-fixtures", null)));
        } else if (dependency instanceof ProjectDependency) {
            ProjectDependency projectDependency = (ProjectDependency)Cast.uncheckedCast(dependency);
            projectDependency.capabilities((Action)new ProjectTestFixtures(projectDependency.getDependencyProject()));
        } else {
            throw new IllegalStateException("Unknown dependency type: " + dependency.getClass());
        }
        return dependency;
    }
}

