/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.jvm.internal.OutgoingElementsBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.testing.base.TestingExtension;

public class JavaPlugin
implements Plugin<Project> {
    public static final String PROCESS_RESOURCES_TASK_NAME = "processResources";
    public static final String CLASSES_TASK_NAME = "classes";
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    public static final String PROCESS_TEST_RESOURCES_TASK_NAME = "processTestResources";
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    public static final String COMPILE_TEST_JAVA_TASK_NAME = "compileTestJava";
    public static final String TEST_TASK_NAME = "test";
    public static final String JAR_TASK_NAME = "jar";
    public static final String JAVADOC_TASK_NAME = "javadoc";
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String IMPLEMENTATION_CONFIGURATION_NAME = "implementation";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String COMPILE_ONLY_CONFIGURATION_NAME = "compileOnly";
    public static final String COMPILE_ONLY_API_CONFIGURATION_NAME = "compileOnlyApi";
    public static final String RUNTIME_ONLY_CONFIGURATION_NAME = "runtimeOnly";
    public static final String RUNTIME_CLASSPATH_CONFIGURATION_NAME = "runtimeClasspath";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    public static final String JAVADOC_ELEMENTS_CONFIGURATION_NAME = "javadocElements";
    public static final String SOURCES_ELEMENTS_CONFIGURATION_NAME = "sourcesElements";
    public static final String COMPILE_CLASSPATH_CONFIGURATION_NAME = "compileClasspath";
    public static final String ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "annotationProcessor";
    public static final String TEST_IMPLEMENTATION_CONFIGURATION_NAME = "testImplementation";
    public static final String TEST_COMPILE_ONLY_CONFIGURATION_NAME = "testCompileOnly";
    public static final String TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "testRuntimeOnly";
    public static final String TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testCompileClasspath";
    public static final String TEST_ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "testAnnotationProcessor";
    public static final String TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "testRuntimeClasspath";
    private static final String SOURCE_ELEMENTS_VARIANT_NAME = "mainSourceElements";
    private final ObjectFactory objectFactory;
    private final SoftwareComponentFactory softwareComponentFactory;
    private final JvmPluginServices jvmServices;

    @Inject
    public JavaPlugin(ObjectFactory objectFactory, SoftwareComponentFactory softwareComponentFactory, JvmPluginServices jvmServices) {
        this.objectFactory = objectFactory;
        this.softwareComponentFactory = softwareComponentFactory;
        this.jvmServices = jvmServices;
    }

    public void apply(Project project) {
        if (project.getPluginManager().hasPlugin("java-platform")) {
            throw new IllegalStateException("The \"java\" or \"java-library\" plugin cannot be applied together with the \"java-platform\" plugin. A project is either a platform or a library but cannot be both at the same time.");
        }
        ProjectInternal projectInternal = (ProjectInternal)project;
        project.getPluginManager().apply(JavaBasePlugin.class);
        project.getPluginManager().apply("org.gradle.jvm-test-suite");
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet mainSourceSet = (SourceSet)javaExtension.getSourceSets().create("main");
        ((ComponentRegistry)projectInternal.getServices().get(ComponentRegistry.class)).setMainComponent((BuildableJavaComponent)new BuildableJavaComponentImpl(project, mainSourceSet));
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = (BuildOutputCleanupRegistry)projectInternal.getServices().get(BuildOutputCleanupRegistry.class);
        PublishArtifact jarArtifact = JavaPlugin.configureArchives(project, mainSourceSet);
        JavaPlugin.configureBuiltInTest(project, mainSourceSet);
        JavaPlugin.configureSourceSets(javaExtension, buildOutputCleanupRegistry);
        this.createConsumableConfigurations(project, mainSourceSet, jarArtifact);
        JvmPluginsHelper.configureJavaDocTask(null, mainSourceSet, project.getTasks(), javaExtension);
        JavaPlugin.configureBuild(project);
    }

    private static void configureSourceSets(JavaPluginExtension pluginExtension, BuildOutputCleanupRegistry buildOutputCleanupRegistry) {
        pluginExtension.getSourceSets().all(sourceSet -> buildOutputCleanupRegistry.registerOutputs((Object)sourceSet.getOutput()));
    }

    private static void configureBuiltInTest(Project project, SourceSet mainSourceSet) {
        TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
        NamedDomainObjectProvider testSuite = testing.getSuites().register(TEST_TASK_NAME, JvmTestSuite.class, suite -> {
            SourceSet testSourceSet = suite.getSources();
            ConfigurationContainer configurations = project.getConfigurations();
            Configuration testImplementationConfiguration = configurations.getByName(testSourceSet.getImplementationConfigurationName());
            Configuration testRuntimeOnlyConfiguration = configurations.getByName(testSourceSet.getRuntimeOnlyConfigurationName());
            Configuration testCompileClasspathConfiguration = configurations.getByName(testSourceSet.getCompileClasspathConfigurationName());
            Configuration testRuntimeClasspathConfiguration = configurations.getByName(testSourceSet.getRuntimeClasspathConfigurationName());
            SourceSetOutput mainSourceSetOutput = mainSourceSet.getOutput();
            SourceSetOutput testSourceSetOutput = testSourceSet.getOutput();
            testSourceSet.setCompileClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{mainSourceSetOutput, testCompileClasspathConfiguration}));
            testSourceSet.setRuntimeClasspath((FileCollection)project.getObjects().fileCollection().from(new Object[]{testSourceSetOutput, mainSourceSetOutput, testRuntimeClasspathConfiguration}));
            testImplementationConfiguration.extendsFrom(new Configuration[]{configurations.getByName(mainSourceSet.getImplementationConfigurationName())});
            testRuntimeOnlyConfiguration.extendsFrom(new Configuration[]{configurations.getByName(mainSourceSet.getRuntimeOnlyConfigurationName())});
        });
        testSuite.get();
        project.getTasks().named("check", task -> task.dependsOn(new Object[]{testSuite}));
    }

    private static PublishArtifact configureArchives(Project project, SourceSet mainSourceSet) {
        TaskProvider jarTaskProvider = project.getTasks().register(JAR_TASK_NAME, Jar.class, jar -> {
            jar.setDescription("Assembles a jar archive containing the main classes.");
            jar.setGroup("build");
            jar.from(new Object[]{mainSourceSet.getOutput()});
        });
        project.getTasks().withType(Test.class).configureEach(test -> test.shouldRunAfter(new Object[]{project.getTasks().withType(Jar.class)}));
        LazyPublishArtifact jarArtifact = new LazyPublishArtifact((Provider)jarTaskProvider, ((ProjectInternal)project).getFileResolver());
        ((DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)jarArtifact);
        return jarArtifact;
    }

    private static void addJarArtifactToConfiguration(Configuration configuration, PublishArtifact jarArtifact) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)JAR_TASK_NAME);
    }

    private Configuration createRuntimeElements(Project project, SourceSet mainSourceSet, PublishArtifact jarArtifact) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration defaultConfiguration = configurations.getByName("default");
        Configuration implementationConfiguration = configurations.getByName(IMPLEMENTATION_CONFIGURATION_NAME);
        Configuration runtimeOnlyConfiguration = configurations.getByName(RUNTIME_ONLY_CONFIGURATION_NAME);
        DeprecatableConfiguration runtimeElementsConfiguration = (DeprecatableConfiguration)this.jvmServices.createOutgoingElements(RUNTIME_ELEMENTS_CONFIGURATION_NAME, (Action<? super OutgoingElementsBuilder>)((Action)builder -> builder.fromSourceSet(mainSourceSet).providesRuntime().withDescription("Elements of runtime for main.").extendsFrom(implementationConfiguration, runtimeOnlyConfiguration)));
        defaultConfiguration.extendsFrom(new Configuration[]{runtimeElementsConfiguration});
        runtimeElementsConfiguration.deprecateForDeclaration(new String[]{IMPLEMENTATION_CONFIGURATION_NAME, COMPILE_ONLY_CONFIGURATION_NAME, RUNTIME_ONLY_CONFIGURATION_NAME});
        JavaPlugin.addJarArtifactToConfiguration((Configuration)runtimeElementsConfiguration, jarArtifact);
        this.jvmServices.configureClassesDirectoryVariant((Configuration)runtimeElementsConfiguration, mainSourceSet);
        this.jvmServices.configureResourcesDirectoryVariant((Configuration)runtimeElementsConfiguration, mainSourceSet);
        return runtimeElementsConfiguration;
    }

    private Configuration createApiElements(SourceSet mainSourceSet, PublishArtifact jarArtifact) {
        DeprecatableConfiguration apiElementsConfiguration = (DeprecatableConfiguration)this.jvmServices.createOutgoingElements(API_ELEMENTS_CONFIGURATION_NAME, (Action<? super OutgoingElementsBuilder>)((Action)builder -> builder.fromSourceSet(mainSourceSet).providesApi().withDescription("API elements for main.")));
        apiElementsConfiguration.deprecateForDeclaration(new String[]{IMPLEMENTATION_CONFIGURATION_NAME, COMPILE_ONLY_CONFIGURATION_NAME});
        JavaPlugin.addJarArtifactToConfiguration((Configuration)apiElementsConfiguration, jarArtifact);
        return apiElementsConfiguration;
    }

    private void createSourceElements(Project project, SourceSet mainSourceSet) {
        Configuration variant = (Configuration)project.getConfigurations().create(SOURCE_ELEMENTS_VARIANT_NAME);
        variant.setDescription("List of source directories contained in the Main SourceSet.");
        variant.setVisible(false);
        variant.setCanBeResolved(false);
        variant.setCanBeConsumed(true);
        variant.extendsFrom(new Configuration[]{project.getConfigurations().getByName(IMPLEMENTATION_CONFIGURATION_NAME)});
        variant.attributes(attributes -> {
            attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.objectFactory.named(Bundling.class, "external")));
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objectFactory.named(Category.class, "verification")));
            attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)this.objectFactory.named(VerificationType.class, "main-sources")));
        });
        variant.getOutgoing().artifacts(mainSourceSet.getAllSource().getSourceDirectories().getElements().flatMap(e -> project.provider(() -> e)), artifact -> artifact.setType("directory"));
    }

    private void createConsumableConfigurations(Project project, SourceSet mainSourceSet, PublishArtifact jarArtifact) {
        Configuration runtimeElementsConfiguration = this.createRuntimeElements(project, mainSourceSet, jarArtifact);
        Configuration apiElementsConfiguration = this.createApiElements(mainSourceSet, jarArtifact);
        this.createSourceElements(project, mainSourceSet);
        AdhocComponentWithVariants java = this.softwareComponentFactory.adhoc("java");
        java.addVariantsFromConfiguration(apiElementsConfiguration, (Action)new JavaConfigurationVariantMapping("compile", false));
        java.addVariantsFromConfiguration(runtimeElementsConfiguration, (Action)new JavaConfigurationVariantMapping("runtime", false));
        project.getComponents().add((Object)java);
    }

    private static void configureBuild(Project project) {
        project.getTasks().named("buildNeeded", task -> JavaPlugin.addDependsOnTaskInOtherProjects(task, true, "buildNeeded", TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME));
        project.getTasks().named("buildDependents", task -> JavaPlugin.addDependsOnTaskInOtherProjects(task, false, "buildDependents", TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME));
    }

    private static void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(new Object[]{configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName)});
    }

    private static class BuildableJavaComponentImpl
    implements BuildableJavaComponent {
        private final Project project;
        private final SourceSet mainSourceSet;

        public BuildableJavaComponentImpl(Project project, SourceSet mainSourceSet) {
            this.project = project;
            this.mainSourceSet = mainSourceSet;
        }

        public Collection<String> getBuildTasks() {
            return Collections.singleton("build");
        }

        public FileCollection getRuntimeClasspath() {
            Configuration runtimeClasspath = this.project.getConfigurations().getByName(this.mainSourceSet.getRuntimeClasspathConfigurationName());
            ArtifactView view = runtimeClasspath.getIncoming().artifactView(config -> config.componentFilter(componentId -> {
                if (componentId instanceof OpaqueComponentIdentifier) {
                    DependencyFactoryInternal.ClassPathNotation classPathNotation = ((OpaqueComponentIdentifier)componentId).getClassPathNotation();
                    return classPathNotation != DependencyFactoryInternal.ClassPathNotation.GRADLE_API && classPathNotation != DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY;
                }
                return true;
            }));
            Configuration runtimeElements = this.project.getConfigurations().getByName(this.mainSourceSet.getRuntimeElementsConfigurationName());
            return runtimeElements.getOutgoing().getArtifacts().getFiles().plus(view.getFiles());
        }

        public Configuration getCompileDependencies() {
            return this.project.getConfigurations().getByName(JavaPlugin.COMPILE_CLASSPATH_CONFIGURATION_NAME);
        }
    }
}

