/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen.font.table;

import io.sf.carte.echosvg.svggen.font.table.LookupSubtable;
import io.sf.carte.echosvg.svggen.font.table.LookupSubtableFactory;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Lookup {
    public static final int IGNORE_BASE_GLYPHS = 2;
    public static final int IGNORE_BASE_LIGATURES = 4;
    public static final int IGNORE_BASE_MARKS = 8;
    public static final int MARK_ATTACHMENT_TYPE = 65280;
    private int type;
    private int flag;
    private int subTableCount;
    private int[] subTableOffsets;
    private LookupSubtable[] subTables;

    public Lookup(LookupSubtableFactory lookupSubtableFactory, RandomAccessFile randomAccessFile, int n) throws IOException {
        int n2;
        randomAccessFile.seek(n);
        this.type = randomAccessFile.readUnsignedShort();
        this.flag = randomAccessFile.readUnsignedShort();
        this.subTableCount = randomAccessFile.readUnsignedShort();
        this.subTableOffsets = new int[this.subTableCount];
        this.subTables = new LookupSubtable[this.subTableCount];
        for (n2 = 0; n2 < this.subTableCount; ++n2) {
            this.subTableOffsets[n2] = randomAccessFile.readUnsignedShort();
        }
        for (n2 = 0; n2 < this.subTableCount; ++n2) {
            this.subTables[n2] = lookupSubtableFactory.read(this.type, randomAccessFile, n + this.subTableOffsets[n2]);
        }
    }

    public int getType() {
        return this.type;
    }

    public int getSubtableCount() {
        return this.subTableCount;
    }

    public LookupSubtable getSubtable(int n) {
        return this.subTables[n];
    }
}

