/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen.font;

import io.sf.carte.echosvg.svggen.font.Point;
import io.sf.carte.echosvg.svggen.font.table.GlyphDescription;

public class Glyph {
    private short leftSideBearing;
    private int advanceWidth;
    private Point[] points;

    public Glyph(GlyphDescription glyphDescription, short s, int n) {
        this.leftSideBearing = s;
        this.advanceWidth = n;
        this.describe(glyphDescription);
    }

    public int getAdvanceWidth() {
        return this.advanceWidth;
    }

    public short getLeftSideBearing() {
        return this.leftSideBearing;
    }

    public Point getPoint(int n) {
        return this.points[n];
    }

    public int getPointCount() {
        return this.points.length;
    }

    public void reset() {
    }

    public void scale(int n) {
        for (Point point : this.points) {
            point.x = (point.x << 10) * n >> 26;
            point.y = (point.y << 10) * n >> 26;
        }
        this.leftSideBearing = (short)(this.leftSideBearing * n >> 6);
        this.advanceWidth = this.advanceWidth * n >> 6;
    }

    private void describe(GlyphDescription glyphDescription) {
        int n = 0;
        this.points = new Point[glyphDescription.getPointCount() + 2];
        for (int i = 0; i < glyphDescription.getPointCount(); ++i) {
            boolean bl;
            boolean bl2 = bl = glyphDescription.getEndPtOfContours(n) == i;
            if (bl) {
                ++n;
            }
            this.points[i] = new Point(glyphDescription.getXCoordinate(i), glyphDescription.getYCoordinate(i), (glyphDescription.getFlags(i) & 1) != 0, bl);
        }
        this.points[glyphDescription.getPointCount()] = new Point(0, 0, true, true);
        this.points[glyphDescription.getPointCount() + 1] = new Point(this.advanceWidth, 0, true, true);
    }
}

