/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphicObjectConverter;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import org.w3c.dom.Element;

public class SVGPath
extends SVGGraphicObjectConverter {
    public SVGPath(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public Element toSVG(Shape shape) {
        String string = SVGPath.toSVGPathData(shape, this.getGeneratorContext());
        if (string == null || string.length() == 0) {
            return null;
        }
        Element element = this.getGeneratorContext().getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "path");
        element.setAttributeNS(null, "d", string);
        if (shape.getPathIterator(null).getWindingRule() == 0) {
            element.setAttributeNS(null, "fill-rule", "evenodd");
        }
        return element;
    }

    public static String toSVGPathData(Shape shape, SVGGeneratorContext sVGGeneratorContext) {
        StringBuilder stringBuilder = new StringBuilder(40);
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        int n = 0;
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    stringBuilder.append("M");
                    SVGPath.appendPoint(stringBuilder, fArray[0], fArray[1], sVGGeneratorContext);
                    break;
                }
                case 1: {
                    stringBuilder.append("L");
                    SVGPath.appendPoint(stringBuilder, fArray[0], fArray[1], sVGGeneratorContext);
                    break;
                }
                case 4: {
                    stringBuilder.append("Z");
                    break;
                }
                case 2: {
                    stringBuilder.append("Q");
                    SVGPath.appendPoint(stringBuilder, fArray[0], fArray[1], sVGGeneratorContext);
                    SVGPath.appendPoint(stringBuilder, fArray[2], fArray[3], sVGGeneratorContext);
                    break;
                }
                case 3: {
                    stringBuilder.append("C");
                    SVGPath.appendPoint(stringBuilder, fArray[0], fArray[1], sVGGeneratorContext);
                    SVGPath.appendPoint(stringBuilder, fArray[2], fArray[3], sVGGeneratorContext);
                    SVGPath.appendPoint(stringBuilder, fArray[4], fArray[5], sVGGeneratorContext);
                    break;
                }
                default: {
                    throw new RuntimeException("invalid segmentType:" + n);
                }
            }
            pathIterator.next();
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString().trim();
        }
        return "";
    }

    private static void appendPoint(StringBuilder stringBuilder, float f, float f2, SVGGeneratorContext sVGGeneratorContext) {
        stringBuilder.append(sVGGeneratorContext.doubleString(f));
        stringBuilder.append(" ");
        stringBuilder.append(sVGGeneratorContext.doubleString(f2));
        stringBuilder.append(" ");
    }
}

