/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.SVGColor;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGPaintDescriptor;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLinearGradient
extends AbstractSVGConverter {
    public SVGLinearGradient(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        Paint paint = graphicContext.getPaint();
        return this.toSVG((GradientPaint)paint);
    }

    public SVGPaintDescriptor toSVG(GradientPaint gradientPaint) {
        SVGPaintDescriptor sVGPaintDescriptor = (SVGPaintDescriptor)this.descMap.get(gradientPaint);
        Document document = this.getGeneratorContext().getDOMFactory();
        if (sVGPaintDescriptor == null) {
            Element element = document.createElementNS("http://www.w3.org/2000/svg", "linearGradient");
            element.setAttributeNS(null, "gradientUnits", "userSpaceOnUse");
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            element.setAttributeNS(null, "x1", this.doubleString(point2D.getX()));
            element.setAttributeNS(null, "y1", this.doubleString(point2D.getY()));
            element.setAttributeNS(null, "x2", this.doubleString(point2D2.getX()));
            element.setAttributeNS(null, "y2", this.doubleString(point2D2.getY()));
            String string = "pad";
            if (gradientPaint.isCyclic()) {
                string = "reflect";
            }
            element.setAttributeNS(null, "spreadMethod", string);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "stop");
            element2.setAttributeNS(null, "offset", "0%");
            SVGPaintDescriptor sVGPaintDescriptor2 = SVGColor.toSVG(gradientPaint.getColor1(), this.getGeneratorContext());
            element2.setAttributeNS(null, "stop-color", sVGPaintDescriptor2.getPaintValue());
            element2.setAttributeNS(null, "stop-opacity", sVGPaintDescriptor2.getOpacityValue());
            element.appendChild(element2);
            element2 = document.createElementNS("http://www.w3.org/2000/svg", "stop");
            element2.setAttributeNS(null, "offset", "100%");
            sVGPaintDescriptor2 = SVGColor.toSVG(gradientPaint.getColor2(), this.getGeneratorContext());
            element2.setAttributeNS(null, "stop-color", sVGPaintDescriptor2.getPaintValue());
            element2.setAttributeNS(null, "stop-opacity", sVGPaintDescriptor2.getOpacityValue());
            element.appendChild(element2);
            element.setAttributeNS(null, "id", this.getGeneratorContext().getIDGenerator().generateID("linearGradient"));
            StringBuilder stringBuilder = new StringBuilder("url(");
            stringBuilder.append("#");
            stringBuilder.append(element.getAttributeNS(null, "id"));
            stringBuilder.append(")");
            sVGPaintDescriptor = new SVGPaintDescriptor(stringBuilder.toString(), "1", element);
            this.descMap.put(gradientPaint, sVGPaintDescriptor);
            this.defSet.add(element);
        }
        return sVGPaintDescriptor;
    }
}

